/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.HashMap;
import net.sf.tacos.ajax.AjaxDirectService;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.listener.ListenerInvoker;

public abstract class InlineEditBox
extends AbstractComponent
implements IDirect {
    private static final Log log = LogFactory.getLog((Class)InlineEditBox.class);

    public abstract AjaxDirectService getAjaxEngine();

    public abstract ListenerInvoker getListenerInvoker();

    public abstract IScript getScript();

    public abstract IActionListener getListener();

    public abstract boolean isDirect();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void setValueUpdate(boolean var1);

    public abstract boolean isValueUpdate();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object value = this.getBinding("value").getObject();
        boolean ajaxRequest = this.getAjaxEngine().getAjaxRequest().isValidRequest();
        if (ajaxRequest && this.isValueUpdate()) {
            this.getAjaxEngine().getAjaxRequest().getResponseBuilder().removeComponentWriter(this.getId());
            if (value == null) {
                value = "";
            }
            this.getAjaxEngine().getAjaxRequest().getResponseBuilder().getScriptWriter().printRaw("<script type=\"text/javascript\">var ew = dojo.widget.byId('" + this.getId() + "Editor');" + " if (ew) ew.setText('" + value.toString() + "');" + "</script>");
            return;
        }
        if (ajaxRequest && !this.getAjaxEngine().getAjaxRequest().containsComponentId(this.getId()) && writer instanceof NullWriter) {
            return;
        }
        writer.begin("span");
        writer.attribute("id", this.getId());
        writer.end();
        HashMap<String, Object> scriptParms = new HashMap<String, Object>();
        AjaxDirectServiceParameter dsp = new AjaxDirectServiceParameter((IDirect)this, (Object[])new String[]{this.getId()}, new String[]{this.getId()}, this.isDirect());
        scriptParms.put("updateUrl", this.getAjaxEngine().getLink(false, (Object)dsp).getAbsoluteURL());
        scriptParms.put("fieldName", this.getId());
        scriptParms.put("fieldValue", this.getValue() != null ? this.getValue().toString() : "");
        scriptParms.put("ajax", ajaxRequest);
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }

    public void trigger(IRequestCycle cycle) {
        IActionListener listener = this.getListener();
        String paramName = (String)cycle.getListenerParameters()[0];
        String value = cycle.getParameter(paramName);
        log.debug((Object)("InlineEditBox paramName:" + paramName + " value:" + value));
        cycle.setListenerParameters((Object[])new String[]{value});
        this.getBinding("value").setObject((Object)value);
        this.setValueUpdate(true);
        if (listener == null) {
            return;
        }
        this.getListenerInvoker().invokeListener(listener, (IComponent)this, cycle);
    }
}

