/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components.grid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tacos.ajax.components.grid.GridColumn;
import net.sf.tacos.ajax.components.grid.GridColumnModel;
import net.sf.tacos.ajax.components.grid.GridModel;
import net.sf.tacos.ajax.components.grid.GridParameterWriter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Messages;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;

public abstract class Grid
extends BaseComponent {
    private static final Log log = LogFactory.getLog((Class)Grid.class);
    private Messages messages;
    private GridModel tableModel = null;

    public abstract String getWidgetId();

    public abstract String getTitle();

    public abstract String getInfo();

    public abstract Integer getPageSize();

    public abstract String getInitialSortColumn();

    public abstract boolean getInitialSortOrder();

    public abstract void setRow(Object var1);

    public abstract boolean isEnableMultipleSelect();

    public abstract boolean isShowFilter();

    public abstract Object getFooterRow();

    public abstract boolean isFooter();

    public abstract String getRowAlternateClass();

    public abstract String getBodyClass();

    public abstract String getHeaderClass();

    public abstract String getFooterClass();

    public abstract String getContainerClass();

    public abstract String getHeaderSortUpClass();

    public abstract String getHeaderSortDownClass();

    public abstract String getLanguage();

    public abstract IScript getScript();

    public List getSource() {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getData();
    }

    public GridColumnModel getColumns() {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getColumnModel();
    }

    public GridModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(GridModel tableModel) {
        this.tableModel = tableModel;
    }

    public void setColumns(GridColumnModel columnModel) {
        if (this.tableModel == null) {
            this.tableModel = new GridModel(columnModel, null);
        }
        this.tableModel.setColumnModel(columnModel);
    }

    public void setSource(List data) {
        if (this.tableModel == null) {
            this.tableModel = new GridModel(null, data);
        }
        this.tableModel.setData(data);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            log.debug((Object)"cycle.isRewinding");
            return;
        }
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        writer.begin("div");
        writer.attribute("id", this.getWidgetId());
        writer.end();
        GridParameterWriter attrWriter = new GridParameterWriter();
        if (this.getPageSize() != null) {
            attrWriter.attribute("maxRows", this.getPageSize());
        }
        attrWriter.attribute("enableMultipleSelect", this.isEnableMultipleSelect());
        if (this.getRowAlternateClass() != null) {
            attrWriter.attribute("rowAlternateClass", this.getRowAlternateClass());
        }
        if (this.getBodyClass() != null) {
            attrWriter.attribute("tbodyClass", this.getBodyClass());
        }
        if (this.getHeaderClass() != null) {
            attrWriter.attribute("headerClass", this.getHeaderClass());
        }
        if (this.getFooterClass() != null) {
            attrWriter.attribute("tfootClass", this.getFooterClass());
        }
        if (this.getContainerClass() != null) {
            attrWriter.attribute("containerClass", this.getContainerClass());
        }
        if (this.getHeaderSortUpClass() != null) {
            attrWriter.attribute("headerSortUpClass", this.getHeaderSortUpClass());
        }
        if (this.getHeaderSortDownClass() != null) {
            attrWriter.attribute("headerSortDownClass", this.getHeaderSortDownClass());
        }
        if (this.getLanguage() != null) {
            attrWriter.attribute("language", this.getLanguage());
        }
        this.renderInformalParameters(attrWriter, cycle);
        attrWriter.attribute("widgetId", this.getId());
        Map attributes = attrWriter.getAttributes();
        StringBuffer attrSb = new StringBuffer("{\n");
        Iterator i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            attrSb.append(name);
            attrSb.append(":");
            if (value == null) {
                attrSb.append("null");
            } else if (value instanceof String) {
                attrSb.append("\"");
                attrSb.append(value);
                attrSb.append("\"");
            } else {
                attrSb.append(value);
            }
            if (i.hasNext()) {
                attrSb.append(",");
            }
            attrSb.append("\n");
        }
        attrSb.append("}");
        this.writeScript(cycle, pageRenderSupport, attrSb.toString());
        this.writeTable(writer);
    }

    private Messages getLocalesMessages() {
        if (this.messages == null) {
            this.messages = this.getPage().getMessages();
        }
        return this.messages;
    }

    private String getMessageByKey(String key) {
        log.debug((Object)("getMessageByKey(): " + key));
        if (key == null || this.getLocalesMessages() == null) {
            return null;
        }
        String message = this.getLocalesMessages().getMessage(key);
        log.debug((Object)("getMessageByKey(): " + message));
        if (message.startsWith("[")) {
            return key;
        }
        return message;
    }

    private void writeTable(IMarkupWriter writer) {
        writer.printRaw("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/grid.css\" media=\"screen\">\n");
        writer.printRaw("<script type=\"text/javascript\"><!--\n");
        writer.printRaw("var " + this.getId() + "_getData = function(){\n");
        writer.printRaw("var " + this.getId() + "_result={\n");
        if (this.getTitle() != null) {
            writer.printRaw("title:\"" + this.getTitle() + "\",");
        }
        this.writeTableMetadata(writer);
        this.writeTableData(writer);
        writer.printRaw(this.getId() + "_contentCallBack(" + this.getId() + "_result);\n");
        writer.printRaw("};\n");
        writer.printRaw("function " + this.getId() + "_contentCallBack(" + this.getId() + "_result){\n");
        writer.printRaw("var w=dojo.widget.byId(\"" + this.getId() + "\");\n");
        writer.printRaw("w.title = " + this.getId() + "_result.title;\n");
        writer.printRaw("w.info = '" + this.getInfo() + "';\n");
        writer.printRaw("w.parseColumns(" + this.getId() + "_result.columns);\n");
        if (this.isFooter()) {
            writer.printRaw("w.hasFooter=true;\n");
        }
        writer.printRaw("w.parseData(" + this.getId() + "_result.rows);\n");
        writer.printRaw("w.showFilter=" + this.isShowFilter() + ";\n");
        this.writeInitialSorting(writer);
        writer.printRaw("w.render();\n");
        writer.printRaw("}\n");
        writer.printRaw("dojo.addOnLoad(" + this.getId() + "_getData);\n");
        writer.printRaw("// --></script>\n");
    }

    private void writeInitialSorting(IMarkupWriter writer) {
        log.debug((Object)"Get initial sorting");
        if (this.getInitialSortColumn() != null) {
            String initialSortColumn = this.getInitialSortColumn();
            boolean initialSortOrder = this.getInitialSortOrder();
            int sortDirection = initialSortOrder ? 1 : 0;
            GridColumn colSorting = this.getColumns().getColumnByName(initialSortColumn);
            Integer sortIndex = colSorting.getIndex();
            writer.printRaw("w.sortIndex=" + sortIndex + ";\n");
            writer.printRaw("w.sortDirection=" + sortDirection + ";\n");
        }
    }

    private void writeTableData(IMarkupWriter writer) {
        log.debug((Object)"Building Grid Data");
        List data = null;
        GridColumnModel columns = null;
        if (this.getSource() == null || this.getColumns() == null) {
            throw new ApplicationRuntimeException("Either the 'tableModel'\nor both 'source' and 'columns' parameters must be provided");
        }
        data = this.getSource();
        columns = this.getColumns();
        if (data == null || columns == null) {
            throw new ApplicationRuntimeException("Columns or Data is not defined");
        }
        Iterator rowIter = data.iterator();
        IBinding rowBinding = this.getBinding("row");
        writer.printRaw("rows:[\n");
        while (rowIter.hasNext()) {
            Object row = rowIter.next();
            if (rowBinding != null) {
                this.setRow(row);
            }
            Iterator colIter = columns.getColumns().iterator();
            writer.printRaw("{");
            while (colIter.hasNext()) {
                String prop = ((GridColumn)colIter.next()).getName();
                writer.printRaw(prop + ":");
                Object val = "";
                try {
                    val = PropertyUtils.getProperty(row, (String)prop);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                String valType = this.getColumns().getColumnTypeByName(prop);
                if (val == null || "Number".equalsIgnoreCase(valType)) {
                    writer.printRaw("" + val);
                } else {
                    writer.printRaw("\"" + StringEscapeUtils.escapeJava((String)("" + val)) + "\"");
                }
                if (!colIter.hasNext()) continue;
                writer.printRaw(",");
            }
            writer.printRaw("}");
            if (rowIter.hasNext()) {
                writer.printRaw(",");
            }
            writer.printRaw("\n");
        }
        writer.printRaw("]};\n");
    }

    private void writeTableMetadata(IMarkupWriter writer) {
        log.debug((Object)"Building Grid Metadata");
        List cols = null;
        if (this.getColumns() != null) {
            cols = this.getColumns().getColumns();
        } else if (this.getTableModel() != null) {
            cols = this.getTableModel().getColumnModel().getColumns();
        } else {
            throw new ApplicationRuntimeException("Either the 'tableModel'\nor both 'source' and 'columns' parameters must be provided");
        }
        if (cols == null) {
            throw new ApplicationRuntimeException("Columns is not defined");
        }
        writer.printRaw("columns:[\n");
        Iterator colIter = cols.iterator();
        Iterator colIterNext = cols.iterator();
        if (colIterNext.hasNext()) {
            colIterNext.next();
        }
        while (colIter.hasNext()) {
            GridColumn col = (GridColumn)colIter.next();
            GridColumn colNext = null;
            if (colIterNext.hasNext()) {
                colNext = (GridColumn)colIterNext.next();
            }
            log.debug((Object)col);
            if (col.isHidden()) continue;
            writer.printRaw("{");
            writer.printRaw("field:\"" + col.getName() + "\"");
            if (col.getDisplayName() != null) {
                String locName = this.getMessageByKey(col.getDisplayName());
                writer.printRaw(",label:\"" + locName + "\"");
            }
            writer.printRaw(",dataType:\"" + col.getDataType() + "\"");
            if (col.getFormatter() != null) {
                writer.printRaw(",format:\"" + col.getFormatter() + "\"");
            }
            writer.printRaw(",noSort:" + !col.isSortable());
            if ("String".equals(col.getDataType()) && !col.isCaseSensitive()) {
                writer.printRaw(",sortFunction:function(value1,value2){ if (value1.toLowerCase()>value2.toLowerCase()) { return 1; } else if (value1.toLowerCase()<value2.toLowerCase()) { return -1; } return 0; }");
                writer.printRaw(",filtCaseIns:true");
            }
            if (col.getAlign() != null) {
                writer.printRaw(",align:\"" + col.getAlign() + "\"");
            }
            if (col.getValign() != null) {
                writer.printRaw(",valign:\"" + col.getValign() + "\"");
            }
            if (col.getCss() != null) {
                writer.printRaw(",cls:\"" + col.getCss() + "\"");
            }
            if (col.getTotalJSfunction() != null) {
                writer.printRaw(",getTotal:" + col.getTotalJSfunction());
            }
            writer.printRaw("}");
            if (colIter.hasNext() && colNext != null && !colNext.isHidden()) {
                writer.printRaw(",");
            }
            writer.printRaw("\n");
        }
        writer.printRaw("],\n");
    }

    private void writeScript(IRequestCycle cycle, PageRenderSupport pageRenderSupport, String widgetParams) {
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("divId", this.getWidgetId());
        symbols.put("widgetParams", widgetParams);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, symbols);
    }
}

