/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.contrib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.ResponseBuilder;
import net.sf.tacos.util.ScriptUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.form.IFormComponent;

public class DojoResponseBuilder
implements ResponseBuilder {
    private static final Log log = LogFactory.getLog((Class)DojoResponseBuilder.class);
    public static final String CONTENT_TYPE = "text/xml";
    public static final String JS_INCLUDES_ID = "jsincludes";
    protected AjaxWebRequest ajaxRequest;
    protected IMarkupWriter writer;
    protected Map writers = new HashMap();
    protected NestedMarkupWriter includeWriter;
    protected NestedMarkupWriter statusWriter;
    protected NestedMarkupWriter preprocessWriter;
    protected NestedMarkupWriter postprocessWriter;
    protected NestedMarkupWriter exceptionWriter;
    static /* synthetic */ Class class$net$sf$tacos$ajax$components$PartialForBean;

    public IMarkupWriter getWriter(IComponent component, IRequestCycle cycle, IMarkupWriter cwriter) {
        if (!NullWriter.class.isInstance(cwriter)) {
            return cwriter;
        }
        String id = this.getComponentId(component);
        if (this.ajaxRequest.containsComponentId(id)) {
            return this.getComponentWriter(id);
        }
        return cwriter;
    }

    public void updateComponentsDirect(IRequestCycle cycle, IPage activePage, IPage componentPage, IComponent component) {
        Collection col = activePage.getComponents().values();
        IComponent[] comps = col.toArray(new IComponent[col.size()]);
        for (int i = 0; i < comps.length; ++i) {
            String id;
            IComponent container = this.checkComponentContainers(comps[i]);
            if (container != null) {
                id = this.getComponentId(container);
                if (this.ajaxRequest.containsComponentId(id)) {
                    container.render(this.getComponentWriter(id), cycle);
                } else {
                    container.render(NullWriter.getSharedInstance(), cycle);
                }
            }
            if (!this.ajaxRequest.containsComponentId(id = this.getComponentId(comps[i]))) continue;
            comps[i].render(this.getComponentWriter(id), cycle);
        }
    }

    protected String getComponentId(IComponent comp) {
        String id = null;
        if (comp instanceof IFormComponent) {
            id = ((IFormComponent)comp).getClientId();
        }
        if (id != null) {
            return id;
        }
        id = comp.getId();
        if (comp.getBinding("id") != null && comp.getBinding("id").getObject() != null) {
            id = comp.getBinding("id").getObject().toString();
        }
        return id;
    }

    protected IComponent checkComponentContainers(IComponent comp) {
        if (comp == null) {
            return null;
        }
        log.debug((Object)("Checking component container for comp class:" + comp.getClass().getName()));
        IComponent container = comp;
        IComponent parent = comp;
        while (parent.getContainer() != null) {
            parent = parent.getContainer();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looping on container class:" + parent.getClass().getName()));
            }
            if (!(class$net$sf$tacos$ajax$components$PartialForBean == null ? DojoResponseBuilder.class$("net.sf.tacos.ajax.components.PartialForBean") : class$net$sf$tacos$ajax$components$PartialForBean).isAssignableFrom(parent.getClass())) continue;
            container = parent;
        }
        return container;
    }

    public void prepareForRender() {
        this.writer.printRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.printRaw("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\" [\n<!ENTITY nbsp '&#160;'>\n]>\n");
        this.writer.printRaw("<ajax-response>");
    }

    public void renderResponse(IRequestCycle cycle, IPage activePage, IPage componentPage, IComponent component) {
        IMarkupWriter nullWriter = NullWriter.getSharedInstance();
        cycle.renderPage(nullWriter);
    }

    public void cleanupAfterRender() {
        if (this.exceptionWriter != null) {
            this.exceptionWriter.end();
            this.writer.printRaw(this.exceptionWriter.getBuffer());
        }
        Iterator keyIt = this.writers.keySet().iterator();
        while (keyIt.hasNext()) {
            String id = (String)keyIt.next();
            NestedMarkupWriter nwriter = (NestedMarkupWriter)this.writers.get(id);
            log.debug((Object)("cleanupAfterRender() on id:" + id));
            if (!this.ajaxRequest.isProcessScripts() && id.equals("scriptblock")) continue;
            this.writer.begin("response");
            this.writer.attribute("type", "element");
            this.writer.attribute("id", id);
            if (this.ajaxRequest.isProcessScripts()) {
                String buffer = nwriter.getBuffer();
                StringBuffer jsIncludes = new StringBuffer();
                ScriptUtils.parseJSIncludes(buffer, jsIncludes);
                if (jsIncludes.length() > 0) {
                    this.getIncludeWriter().printRaw(jsIncludes.toString());
                }
                this.writer.printRaw(ScriptUtils.ensureValidScriptTags(buffer));
            } else if (this.exceptionWriter != null) {
                this.writer.printRaw(nwriter.getBuffer());
            }
            this.writer.end();
        }
        if (this.includeWriter != null) {
            this.includeWriter.end();
            this.writer.printRaw(this.includeWriter.getBuffer());
        }
        if (this.statusWriter != null) {
            this.statusWriter.end();
            this.writer.printRaw(this.statusWriter.getBuffer());
        }
        if (this.preprocessWriter != null) {
            this.preprocessWriter.end();
            this.writer.printRaw(this.preprocessWriter.getBuffer());
        }
        if (this.postprocessWriter != null) {
            this.postprocessWriter.end();
            this.writer.printRaw(this.postprocessWriter.getBuffer());
        }
        this.writers.clear();
        this.writer.printRaw("</ajax-response>");
        this.writer.flush();
    }

    public IMarkupWriter getComponentWriter(String id) {
        IMarkupWriter w = (IMarkupWriter)this.writers.get(id);
        if (w != null) {
            return w;
        }
        NestedMarkupWriter nestedWriter = this.writer.getNestedWriter();
        this.writers.put(id, nestedWriter);
        return nestedWriter;
    }

    public void removeComponentWriter(String id) {
        this.writers.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMarkupWriter getIncludeWriter() {
        IMarkupWriter iMarkupWriter = this.writer;
        synchronized (iMarkupWriter) {
            if (this.includeWriter == null) {
                this.includeWriter = this.writer.getNestedWriter();
                this.includeWriter.begin("response");
                this.includeWriter.attribute("type", "element");
                this.includeWriter.attribute("id", JS_INCLUDES_ID);
            }
        }
        return this.includeWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMarkupWriter getStatusWriter() {
        IMarkupWriter iMarkupWriter = this.writer;
        synchronized (iMarkupWriter) {
            if (this.statusWriter == null) {
                this.statusWriter = this.writer.getNestedWriter();
                this.statusWriter.begin("response");
                this.statusWriter.attribute("type", "statustext");
            }
        }
        return this.statusWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreProcessScript(String script) {
        IMarkupWriter iMarkupWriter = this.writer;
        synchronized (iMarkupWriter) {
            if (this.preprocessWriter == null) {
                this.preprocessWriter = this.writer.getNestedWriter();
                this.preprocessWriter.begin("response");
                this.preprocessWriter.attribute("type", "element");
                this.preprocessWriter.attribute("id", "preprocess");
            }
        }
        this.preprocessWriter.printRaw(ScriptUtils.ensureValidScriptTags(script));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostProcessScript(String script) {
        IMarkupWriter iMarkupWriter = this.writer;
        synchronized (iMarkupWriter) {
            if (this.postprocessWriter == null) {
                this.postprocessWriter = this.writer.getNestedWriter();
                this.postprocessWriter.begin("response");
                this.postprocessWriter.attribute("type", "element");
                this.postprocessWriter.attribute("id", "postprocess");
            }
        }
        this.postprocessWriter.printRaw(ScriptUtils.ensureValidScriptTags(script));
    }

    public boolean componentWriterExists(String id) {
        return this.writers.get(id) != null;
    }

    public void addResponseBlock(String id, String data) {
        IMarkupWriter writer = this.getComponentWriter(id);
        writer.printRaw(data);
    }

    public void addStatusResponse(String status) {
        this.getStatusWriter().printRaw(status);
    }

    public IMarkupWriter getScriptWriter() {
        return this.getComponentWriter("scriptblock");
    }

    public AjaxWebRequest getAjaxRequest() {
        return this.ajaxRequest;
    }

    public void setAjaxRequest(AjaxWebRequest ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public IMarkupWriter getWriter() {
        return this.writer;
    }

    public void setWriter(IMarkupWriter writer) {
        this.writer = writer;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public void addExceptionResponse(IPage exceptionPage, IRequestCycle cycle) {
        exceptionPage.renderPage(this.getExceptionWriter(), cycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMarkupWriter getExceptionWriter() {
        IMarkupWriter iMarkupWriter = this.writer;
        synchronized (iMarkupWriter) {
            if (this.exceptionWriter == null) {
                this.exceptionWriter = this.writer.getNestedWriter();
                this.exceptionWriter.begin("response");
                this.exceptionWriter.attribute("type", "exception");
            }
        }
        return this.exceptionWriter;
    }
}

