/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.components.maps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tacos.components.maps.GMapLicense;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Resource;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.asset.ExternalResource;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.spec.IComponentSpecification;

public abstract class GMap
extends BaseComponent {
    private static final Log log = LogFactory.getLog((Class)GMap.class);
    private static final String ATTRIBUTE_NAME = GMap.class.getName();
    private List smallAssetlist = new ArrayList();
    private List bigAssetlist = new ArrayList();
    private Map injectedKeys;

    public abstract String getIdParameter();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getVersion();

    public abstract int getZoom();

    public abstract double getCoordX();

    public abstract double getCoordY();

    public abstract String getType();

    public abstract List getKeys();

    public abstract String getKey();

    public abstract boolean getShowZoom();

    public abstract boolean getShowType();

    public abstract boolean getShowScale();

    public abstract IScript getScript();

    public abstract String getServerName();

    public abstract Integer getServerPort();

    public static GMap get(IRequestCycle cycle) {
        return (GMap)((Object)cycle.getAttribute(ATTRIBUTE_NAME));
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (GMap.get(cycle) != null) {
            throw new ApplicationRuntimeException("GMap components should NOT nest.", (Object)this, this.getLocation(), null);
        }
        cycle.setAttribute(ATTRIBUTE_NAME, (Object)this);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        super.renderComponent(writer, cycle);
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        String mapType = "G_MAP_TYPE";
        if ("satellite".equals(this.getType())) {
            mapType = "G_SATELLITE_TYPE";
        } else if ("hybrid".equals(this.getType())) {
            mapType = "G_HYBRID_TYPE";
        }
        symbols.put("id", this.getIdParameter());
        symbols.put("coordX", String.valueOf(this.getCoordX()));
        symbols.put("coordY", String.valueOf(this.getCoordY()));
        symbols.put("zoom", String.valueOf(this.getZoom()));
        symbols.put("mapType", mapType);
        symbols.put("showZoom", this.getShowZoom());
        symbols.put("showType", this.getShowType());
        symbols.put("showScale", this.getShowScale());
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, symbols);
        String key = this.findMatchingKey();
        String path = "http://maps.google.com/maps?file=api&v=" + this.getVersion() + "&key=" + key;
        pageRenderSupport.addExternalScript((Resource)new ExternalResource(path, null));
    }

    public void finishLoad(IRequestCycle cycle, IPageLoader loader, IComponentSpecification spec) {
        super.finishLoad(cycle, loader, spec);
        if (this.injectedKeys == null) {
            this.injectedKeys = new HashMap();
            Iterator iter = this.getKeys().iterator();
            while (iter.hasNext()) {
                GMapLicense lic = (GMapLicense)iter.next();
                this.injectedKeys.put(lic.getUrl(), lic.getKey());
            }
        }
    }

    private String findMatchingKey() {
        String key = this.getKey();
        if (key == null) {
            String lookFor = this.getServerName() + ":" + this.getServerPort();
            key = (String)this.injectedKeys.get(lookFor);
        }
        return key;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        super.cleanupAfterRender(cycle);
        cycle.removeAttribute(ATTRIBUTE_NAME);
        this.smallAssetlist.clear();
        this.bigAssetlist.clear();
    }
}

