/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.formatter;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import net.sf.tacos.ajax.AjaxUtils;
import net.sf.tacos.formatter.JsFormatter;
import net.sf.tacos.util.ScriptUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.IScriptSource;

public class DateJsFormatter
implements JsFormatter {
    private static final Log log = LogFactory.getLog((Class)DateJsFormatter.class);
    public static final String FORMATTER_SCRIPT_RESOURCE = "/net/sf/tacos/formatter/DateFormatter.script";
    private String format = "%m/%d/%Y";
    private String ignoreSeparators = "true";
    private String separator = "/";
    private String amSymbol;
    private String pmSymbol;

    public DateJsFormatter() {
    }

    public DateJsFormatter(String initializer) {
        PropertyUtils.configureProperties((Object)this, (String)initializer);
    }

    public void renderContributions(IRequestCycle cycle, IScriptSource scriptSource, IComponent comp, String uniqueId) {
        log.debug((Object)("Rendering contributions for: " + comp.getId()));
        Locale locale = comp.getPage().getLocale();
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        String[] amPmStrings = dfs.getAmPmStrings();
        String realAmSymbol = StringUtils.isEmpty((String)this.amSymbol) ? amPmStrings[0] : this.amSymbol;
        String realPmSymbol = StringUtils.isEmpty((String)this.pmSymbol) ? amPmStrings[1] : this.pmSymbol;
        String fieldId = ScriptUtils.getFieldId(comp, uniqueId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("format", StringUtils.trimToNull((String)this.format));
        params.put("ignoreSeparators", StringUtils.trimToNull((String)this.ignoreSeparators));
        params.put("separator", StringUtils.trimToNull((String)this.separator));
        params.put("amSymbol", StringUtils.trimToNull((String)realAmSymbol));
        params.put("pmSymbol", StringUtils.trimToNull((String)realPmSymbol));
        params.put("componentId", StringUtils.trimToNull((String)fieldId));
        params.put("ajax", AjaxUtils.isAjaxCycle(cycle));
        PageRenderSupport prs = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)comp);
        Location location = comp.getSpecification().getLocation();
        ClasspathResource resource = new ClasspathResource((ClassResolver)new DefaultClassResolver(), FORMATTER_SCRIPT_RESOURCE);
        IScript script = scriptSource.getScript((Resource)resource);
        script.execute(cycle, (IScriptProcessor)prs, params);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getIgnoreSeparators() {
        return this.ignoreSeparators;
    }

    public void setIgnoreSeparators(String ignoreSeparators) {
        this.ignoreSeparators = ignoreSeparators;
    }

    public void setAmSymbol(String amSymbol) {
        this.amSymbol = amSymbol;
    }

    public String getAmSymbol() {
        return this.amSymbol;
    }

    public String getPmSymbol() {
        return this.pmSymbol;
    }

    public void setPmSymbol(String pmSymbol) {
        this.pmSymbol = pmSymbol;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this);
        tb.append("format", (Object)this.format);
        tb.append("ignoreSeparators", (Object)this.ignoreSeparators);
        tb.append("amSymbol", (Object)this.amSymbol);
        tb.append("pmSymbol", (Object)this.pmSymbol);
        tb.append("separator", (Object)this.separator);
        return tb.toString();
    }
}

