/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.services.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.tacos.services.CategoryInfo;
import net.sf.tacos.services.PageInfo;
import net.sf.tacos.services.SiteMap;
import net.sf.tacos.services.impl.CategoryInfoImpl;
import net.sf.tacos.services.impl.PageInfoImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.Resource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SiteMapImpl
implements SiteMap {
    private static final Log log = LogFactory.getLog((Class)SiteMapImpl.class);
    private Resource resource;
    private Document document;
    private List cachedCategoryList = null;
    private Map cachedPageMap = new HashMap();
    private Map cachedCategoryInfo = new HashMap();

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void initialize() throws DocumentException {
        if (this.resource == null) {
            throw new IllegalStateException("No resource set, call setResource(..) before initialize()");
        }
        if (this.resource.getResourceURL() == null) {
            throw new IllegalStateException("No valid resource URL could be resolved:" + this.resource);
        }
        log.debug((Object)("Sitemap resource: " + this.resource.getResourceURL()));
        SAXReader reader = new SAXReader();
        this.document = reader.read(this.resource.getResourceURL());
    }

    public boolean contains(String parentName, String pageName) {
        PageInfo pageInfo = this.getPageInfo(pageName);
        return this.containsImpl(parentName, pageInfo);
    }

    private boolean containsImpl(String parentName, PageInfo pageInfo) {
        if (pageInfo == null) {
            return false;
        }
        PageInfo parent = pageInfo.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getName().equals(parentName)) {
            return true;
        }
        return this.containsImpl(parentName, parent);
    }

    public PageInfo getPageInfo(String name) {
        return this.getPageInfoCacheImpl(name, null);
    }

    private PageInfo getPageInfoCacheImpl(String name, String source) {
        PageInfo pi = (PageInfo)this.cachedPageMap.get(name);
        if (pi == null && (pi = this.getPageInfoImpl(name, source)) != null) {
            this.cachedPageMap.put(name, pi);
        }
        return pi;
    }

    private PageInfo getPageInfoImpl(String name, String source) {
        if (this.document == null) {
            throw new IllegalStateException("No document set, call setResource and initialize.");
        }
        if (source != null && name.equals(source)) {
            throw new IllegalStateException("Found a cycle, " + name + "->" + source);
        }
        if (source == null) {
            source = name;
        }
        log.debug((Object)("Getting page info for: " + name));
        Element node = this.findPageNode(name);
        if (node != null) {
            PageInfo page = this.parsePageNode(node);
            Node pageCategoryNode = this.document.selectSingleNode("/sitemap/category//page[@name='" + name + "']");
            if (pageCategoryNode != null) {
                this.parseNodeTree(page, pageCategoryNode);
                return (PageInfo)this.cachedPageMap.get(page.getName());
            }
            return page;
        }
        log.warn((Object)("No page available for: " + name));
        return null;
    }

    protected Element findPageNode(String page) {
        return (Element)this.document.selectSingleNode("/sitemap/page[@name='" + page + "']");
    }

    protected PageInfo parsePageNode(Element node) {
        if (node == null || !node.getName().equals("page")) {
            throw new IllegalArgumentException("Node was null or not a page node.");
        }
        String name = node.attributeValue("name");
        String desc = node.attributeValue("desc");
        String perm = node.attributeValue("permission");
        String listItem = node.attributeValue("navigable");
        log.debug((Object)("Parsed perm of " + perm + " for page <" + name + ">"));
        boolean list = true;
        if (listItem != null && !listItem.trim().equals("")) {
            list = Boolean.valueOf(listItem);
        }
        PageInfoImpl page = new PageInfoImpl(name, desc, perm, new ArrayList(), list);
        return page;
    }

    protected void parseNodeTree(PageInfo page, Node pageNode) {
        Node parent = pageNode;
        while (parent.getParent() != null && parent.getParent().getName().equals("page")) {
            parent = parent.getParent();
        }
        log.debug((Object)("Parsing tree for page <" + page.getName() + ">"));
        this.parsePageNodes(parent, page);
    }

    protected PageInfo parsePageNodes(Node parent, PageInfo source) {
        PageInfo parentInfo = this.parsePageNode(this.findPageNode(((Element)parent).attributeValue("name")));
        this.cachedPageMap.put(parentInfo.getName(), parentInfo);
        log.debug((Object)("Parent page name <" + parent.valueOf("@name") + ">"));
        Iterator it = parent.selectNodes("*").iterator();
        while (it.hasNext()) {
            Node child = (Node)it.next();
            log.debug((Object)("Adding child page name <" + child.valueOf("@name") + ">"));
            PageInfo childInfo = this.parsePageNodes(child, source);
            childInfo.setParent(parentInfo);
            parentInfo.addChild(childInfo);
        }
        return parentInfo;
    }

    public synchronized List getCategories() {
        if (this.document == null) {
            throw new IllegalStateException("No document set, call setResource and initialize.");
        }
        if (this.cachedCategoryList == null) {
            log.debug((Object)"Getting category listing...");
            List nodes = this.document.selectNodes("/sitemap/category[@name]");
            this.cachedCategoryList = new ArrayList(nodes.size());
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                String category = ((Node)nodes.get(i)).valueOf("@name");
                log.debug((Object)("Adding category: " + category));
                this.cachedCategoryList.add(category);
            }
        }
        return this.cachedCategoryList;
    }

    public CategoryInfo getCategoryInfo(String name) {
        List nodes;
        CategoryInfo ci = (CategoryInfo)this.cachedCategoryInfo.get(name);
        if (ci != null) {
            return ci;
        }
        if (this.document == null) {
            throw new IllegalStateException("No document set, call setResource and initialize.");
        }
        log.debug((Object)("Building category info for: " + name));
        String imgName = null;
        String inactiveImgName = null;
        Element catnode = (Element)this.document.selectSingleNode("/sitemap/category[@name='" + name + "']");
        if (catnode != null) {
            imgName = catnode.attributeValue("image-active");
            inactiveImgName = catnode.attributeValue("image-inactive");
        }
        if ((nodes = this.document.selectNodes("/sitemap/category[@name='" + name + "']/page")) != null) {
            ArrayList<String> pageNames = new ArrayList<String>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                String pageName = node.valueOf("@name");
                pageNames.add(pageName);
            }
            ci = new CategoryInfoImpl(name, pageNames, imgName, inactiveImgName);
            this.cachedCategoryInfo.put(name, ci);
            return ci;
        }
        log.debug((Object)("Returning empty category info for: " + name));
        ci = new CategoryInfoImpl(name, null);
        this.cachedCategoryInfo.put(name, ci);
        return ci;
    }

    private PageInfo getOrigin(PageInfo pageInfo) {
        if (pageInfo != null && pageInfo.getParent() != null) {
            return this.getOrigin(pageInfo.getParent());
        }
        return pageInfo;
    }

    public CategoryInfo getCategoryFromPage(String pageName) {
        PageInfo pageInfo = this.getPageInfo(pageName);
        if (pageInfo != null) {
            PageInfo topMostPage = this.getOrigin(pageInfo);
            String topPageName = topMostPage.getName();
            Node node = this.document.selectSingleNode("/sitemap/category/page[@name='" + topPageName + "']");
            if (node != null) {
                String categoryName = node.getParent().valueOf("@name");
                return this.getCategoryInfo(categoryName);
            }
        }
        return null;
    }

    public boolean inCategory(String pageName, String category) {
        CategoryInfo ci = this.getCategoryFromPage(pageName);
        return ci != null && ci.getName().equals(category);
    }

    public PageInfo getDefaultPage(String category) {
        CategoryInfo ci = this.getCategoryInfo(category);
        if (ci == null) {
            return null;
        }
        return this.getPageInfo(ci.getDefaultPage());
    }

    public List getCategoryPages(String pageName) {
        CategoryInfo ci = this.getCategoryFromPage(pageName);
        if (ci == null) {
            return Arrays.asList(new Object[0]);
        }
        return ci.getPageNames();
    }

    public String getDefaultPageDesc(String category) {
        PageInfo pi = this.getDefaultPage(category);
        if (pi == null) {
            return null;
        }
        return pi.getDesc();
    }

    public List getBreadCrumbs(String pageName) {
        LinkedList list = new LinkedList();
        PageInfo pageInfo = this.getPageInfo(pageName);
        if (pageInfo == null) {
            return Arrays.asList(new Object[0]);
        }
        this.loadBreadCrumbs(pageInfo, list);
        return list;
    }

    private void loadBreadCrumbs(PageInfo pageInfo, List breadCrumbs) {
        PageInfo parent = pageInfo.getParent();
        if (parent == null || parent.getName().equals("")) {
            return;
        }
        breadCrumbs.add(0, parent.getName());
        this.loadBreadCrumbs(parent, breadCrumbs);
    }
}

