/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.services.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hivemind.Location;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.binding.AbstractBinding;
import org.apache.tapestry.binding.BindingFactory;
import org.apache.tapestry.coerce.ValueConverter;

public class TemplateBinding
extends AbstractBinding {
    private final IComponent root;
    private String expression;
    private Map variableBindings;
    private BindingFactory nestedBindingFactory;

    public TemplateBinding(String description, Location location, ValueConverter valueConverter, IComponent root, String expression, BindingFactory nestedBindingFactory) {
        super(description, valueConverter, location);
        this.root = root;
        this.expression = this.extractExpression(expression);
        this.nestedBindingFactory = nestedBindingFactory;
        this.buildingVariableBindings();
    }

    private void buildingVariableBindings() {
        int start;
        if (this.variableBindings == null) {
            this.variableBindings = new HashMap();
        }
        String least = this.expression;
        while ((start = least.indexOf("${")) != -1) {
            least = least.substring(start);
            int length = least.indexOf("}");
            String innerExp = least.substring(2, length);
            IBinding expBinding = this.nestedBindingFactory.createBinding(this.root, this.getDescription(), innerExp, this.getLocation());
            this.variableBindings.put("${" + innerExp + "}", expBinding);
            least = least.substring(length + 1);
        }
    }

    private String extractExpression(String expression) {
        if (expression.startsWith("%")) {
            String key = expression.substring(1);
            return this.root.getMessages().getMessage(key);
        }
        return expression;
    }

    public Object getObject() {
        String value = this.expression;
        Iterator it = this.variableBindings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            IBinding exp = (IBinding)entry.getValue();
            String replacement = "";
            Object object = exp.getObject();
            if (object != null) {
                replacement = object.toString();
            }
            value = StringUtils.replace((String)value, (String)key, (String)replacement);
        }
        return value;
    }

    public boolean isInvariant() {
        return false;
    }
}

