/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtpl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jtpl.Jtpl;

public class Template {
    private Jtpl t;

    public Template(Reader template) throws IOException {
        this.t = new Jtpl(template);
    }

    public Template(String templateSource) {
        try {
            this.t = new Jtpl(new StringReader(templateSource));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Template(File templateFile) throws FileNotFoundException {
        FileReader r = new FileReader(templateFile);
        try {
            this.t = new Jtpl(templateFile);
        }
        catch (IOException e) {
            try {
                r.close();
            }
            catch (Exception nothingToDoAboutIt) {
                // empty catch block
            }
        }
    }

    public Template assign(String varName, String varData) {
        this.t.assign(varName, varData);
        return this;
    }

    public Template parse(String blockName) throws IllegalArgumentException {
        this.t.parse(blockName);
        return this;
    }

    public String out() {
        return this.t.out();
    }

    public Template parse(String blockName, Object bean) {
        this.assignAll(bean);
        return this.parse(blockName);
    }

    public String out(Object bean) {
        this.assignAll(bean);
        return this.out();
    }

    protected void assignAll(Object bean) {
        Map p = this.getBeanProperties(bean);
        Iterator i = p.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.assign(key.toUpperCase(), "" + p.get(key));
        }
    }

    protected Map getBeanProperties(Object bean) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (bean == null) {
            return values;
        }
        Method[] m = bean.getClass().getMethods();
        Pattern p = Pattern.compile("get([A-Z]\\w+)");
        for (int i = 0; i < m.length; ++i) {
            Matcher r;
            if (m[i].getName().equals("getClass") || m[i].getParameterTypes().length > 0 || !(r = p.matcher(m[i].getName())).matches()) continue;
            try {
                values.put(r.group(1).toLowerCase(), m[i].invoke(bean, new Object[0]));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return values;
    }
}

