/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.feature;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.maven.feature.ConfigurationException;
import org.codehaus.groovy.maven.feature.Feature;

public final class Configuration
implements Cloneable {
    private Map store;
    private String prefix;
    private Configuration parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Configuration(Map store, String prefix) {
        if (!$assertionsDisabled && store == null) {
            throw new AssertionError();
        }
        this.store = store;
        this.prefix = prefix;
    }

    public Configuration() {
        this(new HashMap(), null);
    }

    public Configuration(Configuration config) {
        this(config.store, config.prefix);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String key(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (this.prefix != null) {
            return this.prefix + "." + name;
        }
        return name;
    }

    public boolean contains(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.store.containsKey(this.key(name));
    }

    public Object set(String name, Object value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        return this.store.put(this.key(name), value);
    }

    public Object get(String name, Object defaultValue) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        Object value = this.store.get(this.key(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Object get(String name) {
        return this.get(name, (Object)null);
    }

    public Object remove(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.store.remove(this.key(name));
    }

    public void merge(Configuration config) {
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        this.store.putAll(config.store);
    }

    public void clear() {
        this.store.clear();
    }

    public int size() {
        if (this.prefix == null) {
            return this.store.size();
        }
        int c = 0;
        Iterator iter = this.store.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(this.prefix)) continue;
            ++c;
        }
        return c;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set names() {
        if (this.prefix == null) {
            return Collections.unmodifiableSet(this.store.keySet());
        }
        HashSet<String> matching = new HashSet<String>();
        int l = this.prefix.length();
        Iterator iter = this.store.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(this.prefix + ".")) continue;
            key = key.substring(l + 1, key.length());
            matching.add(key);
        }
        return Collections.unmodifiableSet(matching);
    }

    public Configuration parent() {
        if (this.parent == null) {
            throw new IllegalStateException("Parent is not bound");
        }
        return this.parent;
    }

    public Configuration child(String prefix) {
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        Configuration child = (Configuration)this.clone();
        child.parent = this;
        child.prefix = child.prefix != null ? child.prefix + prefix : prefix;
        return child;
    }

    public Configuration child(Feature feature) {
        if (!$assertionsDisabled && feature == null) {
            throw new AssertionError();
        }
        return this.child(feature.key());
    }

    public Object set(String name, boolean value) {
        return this.set(name, (Object)value);
    }

    public boolean get(String name, boolean defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(String.valueOf(value));
    }

    public Object set(String name, int value) {
        return this.set(name, new Integer(value));
    }

    public int get(String name, int defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(String.valueOf(value));
    }

    public String get(String name, String defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public File get(String name, File defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof File) {
            return (File)value;
        }
        return new File(String.valueOf(value));
    }

    public URL get(String name, URL defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        try {
            return new URL(String.valueOf(value));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unable to decode URL; name=" + name + ", value=" + value, e);
        }
    }

    public URI get(String name, URI defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof URI) {
            return (URI)value;
        }
        try {
            return new URI(String.valueOf(value));
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Unable to decode URI; name=" + name + ", value=" + value, e);
        }
    }

    static {
        $assertionsDisabled = !Configuration.class.desiredAssertionStatus();
    }
}

