/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.FileResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class DefaultResourceManager
extends AbstractLogEnabled
implements ResourceManager {
    private Map resourceLoaders;
    private File outputDirectory;

    public InputStream getResourceAsInputStream(String name) throws ResourceNotFoundException {
        InputStream is = null;
        Iterator i = this.resourceLoaders.values().iterator();
        while (i.hasNext()) {
            ResourceLoader resourceLoader = (ResourceLoader)i.next();
            try {
                is = resourceLoader.getResourceAsInputStream(name);
                this.getLogger().debug("The resource '" + name + "'" + " found using the " + resourceLoader + ".");
                break;
            }
            catch (ResourceNotFoundException e) {
            }
        }
        if (is == null) {
            throw new ResourceNotFoundException(name);
        }
        return is;
    }

    public File getResourceAsFile(String name) throws ResourceNotFoundException, FileResourceCreationException {
        return this.getResourceAsFile(name, null);
    }

    public File getResourceAsFile(String name, String outputPath) throws ResourceNotFoundException, FileResourceCreationException {
        File f = FileResourceLoader.getResourceAsFile(name, outputPath, this.outputDirectory);
        if (f != null) {
            return f;
        }
        InputStream is = this.getResourceAsInputStream(name);
        InputStreamReader reader = new InputStreamReader(is);
        File outputFile = outputPath == null ? FileUtils.createTempFile((String)"plexus-resources", (String)"tmp", null) : (this.outputDirectory != null ? new File(this.outputDirectory, outputPath) : new File(outputPath));
        try {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(outputFile);
            IOUtil.copy((Reader)reader, (Writer)writer);
        }
        catch (IOException e) {
            throw new FileResourceCreationException("Cannot create file-based resource.", e);
        }
        return outputFile;
    }

    public File resolveLocation(String name, String outputPath) throws IOException {
        try {
            return this.getResourceAsFile(name, outputPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public File resolveLocation(String name) throws IOException {
        System.out.println("name = " + name);
        try {
            return this.getResourceAsFile(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void addSearchPath(String id, String path) {
        ResourceLoader loader = (ResourceLoader)this.resourceLoaders.get(id);
        loader.addSearchPath(path);
    }
}

