/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Iterator;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.gwc.GWCCleanser;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geotools.util.logging.Logging;

public class GWCTransactionListener
implements TransactionListener {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWCTransactionListener");
    private final Catalog cat;
    private final GWCCleanser cleanser;

    public GWCTransactionListener(Catalog cat, GWCCleanser cleanser) {
        this.cat = cat;
        this.cleanser = cleanser;
    }

    public void dataStoreChange(TransactionEvent event) throws WFSException {
        String prefix = null;
        String layerName = null;
        try {
            prefix = this.cat.getNamespaceByURI(event.getLayerName().getNamespaceURI()).getPrefix();
            layerName = String.valueOf(prefix) + ":" + event.getLayerName().getLocalPart();
        }
        catch (NullPointerException npe) {
            log.fine("Null pointer while trying to determine feature prefix. Cache not truncated.");
            return;
        }
        this.cleanser.deleteLayer(layerName);
        Iterator lgiter = this.cat.getLayerGroups().iterator();
        while (lgiter.hasNext()) {
            boolean truncate = false;
            LayerGroupInfo lgi = (LayerGroupInfo)lgiter.next();
            Iterator liter = lgi.getLayers().iterator();
            while (!truncate && liter.hasNext()) {
                LayerInfo li = (LayerInfo)liter.next();
                if (!li.getResource().getPrefixedName().equals(layerName)) continue;
                truncate = true;
            }
            if (!truncate) continue;
            this.cleanser.deleteLayer(lgi.getName());
        }
    }
}

