/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.springframework.util.Assert;

public class GWCConfigPersister {
    private static final Logger LOGGER = Logging.getLogger(GWCConfigPersister.class);
    public static final String GWC_CONFIG_FILE = "gwc-gs.xml";
    private final XStreamPersisterFactory persisterFactory;
    private final GeoServerResourceLoader resourceLoader;
    private GWCConfig config;

    public GWCConfigPersister(XStreamPersisterFactory xspf, GeoServerResourceLoader resourceLoader) {
        this.persisterFactory = xspf;
        this.resourceLoader = resourceLoader;
    }

    File findConfigFile() throws IOException {
        File configFile = this.resourceLoader.find(GWC_CONFIG_FILE);
        return configFile;
    }

    public GWCConfig getConfig() {
        if (this.config == null) {
            try {
                this.loadConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.config;
    }

    private synchronized void loadConfig() throws IOException {
        File configFile = this.findConfigFile();
        Assert.notNull((Object)configFile);
        XStreamPersister xmlPersister = this.persisterFactory.createXMLPersister();
        this.configureXstream(xmlPersister.getXStream());
        try {
            FileInputStream in = new FileInputStream(configFile);
            try {
                this.config = (GWCConfig)xmlPersister.load((InputStream)in, GWCConfig.class);
            }
            finally {
                ((InputStream)in).close();
            }
            LOGGER.fine("GWC GeoServer specific configuration loaded from gwc-gs.xml");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading GWC GeoServer specific configuration from " + configFile.getAbsolutePath() + ". Applying defaults.", e);
            this.config = new GWCConfig();
        }
    }

    public void save(GWCConfig config) throws IOException {
        LOGGER.finer("Saving integrated GWC configuration");
        File tmp = new File(this.getConfigRoot(), "gwc-gs.xml.tmp");
        XStreamPersister xmlPersister = this.persisterFactory.createXMLPersister();
        this.configureXstream(xmlPersister.getXStream());
        FileOutputStream out = new FileOutputStream(tmp);
        try {
            xmlPersister.save((Object)config, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
        File configFile = new File(this.getConfigRoot(), GWC_CONFIG_FILE);
        tmp.renameTo(configFile);
        this.config = config;
        LOGGER.finer("Integrated GWC configuration saved to " + configFile.getAbsolutePath());
    }

    private void configureXstream(XStream xs) {
        xs.alias("GeoServerGWCConfig", GWCConfig.class);
        xs.alias("defaultCachingGridSetIds", HashSet.class);
        xs.alias("defaultCoverageCacheFormats", HashSet.class);
        xs.alias("defaultVectorCacheFormats", HashSet.class);
        xs.alias("defaultOtherCacheFormats", HashSet.class);
    }

    private File getConfigRoot() {
        return this.resourceLoader.getBaseDirectory();
    }
}

