/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.Repository;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogRepository
implements Repository {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    private Catalog catalog;

    public CatalogRepository() {
    }

    public CatalogRepository(Catalog catalog) {
        this.catalog = catalog;
    }

    public DataStore dataStore(Name name) {
        DataAccess<?, ?> da = this.access(name);
        if (da instanceof DataStore) {
            return (DataStore)da;
        }
        LOGGER.severe(name + " is not a data store.");
        return null;
    }

    public DataAccess<?, ?> access(Name name) {
        String workspace = name.getNamespaceURI();
        String localName = name.getLocalPart();
        DataStoreInfo info = this.getCatalog().getDataStoreByName(workspace, localName);
        if (info == null) {
            throw new RuntimeException("Cannot find datastore " + localName + "in workspace " + workspace);
        }
        try {
            return info.getDataStore(null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<DataStore> getDataStores() {
        ArrayList<DataStore> dataStores = new ArrayList<DataStore>();
        for (DataStoreInfo ds : this.getCatalog().getDataStores()) {
            if (!ds.isEnabled()) continue;
            try {
                DataAccess<? extends FeatureType, ? extends Feature> da = ds.getDataStore(null);
                if (!(da instanceof DataStore)) continue;
                dataStores.add((DataStore)da);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to get datastore '" + ds.getName() + "'", e);
            }
        }
        return dataStores;
    }

    public Catalog getCatalog() {
        if (this.catalog != null) {
            return this.catalog;
        }
        this.catalog = (Catalog)GeoServerExtensions.bean(Catalog.class);
        if (this.catalog == null) {
            LOGGER.severe("Could not locate geoserver catalog");
        }
        return this.catalog;
    }
}

