/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.geoserver.security.AccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessRule
implements Comparable<DataAccessRule>,
Serializable {
    public static final String ANY = "*";
    public static DataAccessRule READ_ALL = new DataAccessRule("*", "*", AccessMode.READ, new String[0]);
    public static DataAccessRule WRITE_ALL = new DataAccessRule("*", "*", AccessMode.WRITE, new String[0]);
    String workspace;
    String layer;
    AccessMode accessMode;
    Set<String> roles;

    public DataAccessRule(String workspace, String layer, AccessMode accessMode, Set<String> roles) {
        this.workspace = workspace;
        this.layer = layer;
        this.accessMode = accessMode;
        this.roles = roles == null ? new HashSet<String>() : new HashSet<String>(roles);
    }

    public DataAccessRule(String workspace, String layer, AccessMode accessMode, String ... roles) {
        this(workspace, layer, accessMode, (Set<String>)(roles == null ? null : new HashSet<String>(Arrays.asList(roles))));
    }

    public DataAccessRule(DataAccessRule other) {
        this.workspace = other.workspace;
        this.layer = other.layer;
        this.accessMode = other.accessMode;
        this.roles = new HashSet<String>(other.roles);
    }

    public DataAccessRule() {
        this(ANY, ANY, AccessMode.READ, new String[0]);
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String getKey() {
        return String.valueOf(this.workspace) + "." + this.layer + "." + this.accessMode.getAlias();
    }

    public String getValue() {
        if (this.roles.isEmpty()) {
            return ANY;
        }
        StringBuffer sb = new StringBuffer();
        for (String role : this.roles) {
            sb.append(role);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public int compareTo(DataAccessRule other) {
        int compareWs = this.compareCatalogItems(this.workspace, other.workspace);
        if (compareWs != 0) {
            return compareWs;
        }
        int compareLayer = this.compareCatalogItems(this.layer, other.layer);
        if (compareLayer != 0) {
            return compareLayer;
        }
        if (this.accessMode.equals((Object)other.accessMode)) {
            return 0;
        }
        return this.accessMode.equals((Object)AccessMode.READ) ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataAccessRule)) {
            return false;
        }
        return this.compareTo((DataAccessRule)obj) == 0;
    }

    public boolean equalsExact(DataAccessRule obj) {
        if (this.compareTo(obj) != 0) {
            return false;
        }
        return this.roles.equals(obj.roles);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.workspace).append((Object)this.layer).append((Object)this.accessMode.getAlias()).toHashCode();
    }

    public int compareCatalogItems(String item, String otherItem) {
        if (item.equals(otherItem)) {
            return 0;
        }
        if (ANY.equals(item)) {
            return -1;
        }
        if (ANY.equals(otherItem)) {
            return 1;
        }
        return item.compareTo(otherItem);
    }

    public String toString() {
        return String.valueOf(this.getKey()) + "=" + this.getValue();
    }
}

