/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyFileWatcher {
    File file;
    private long lastModified = Long.MIN_VALUE;
    private long lastCheck;
    private boolean stale;

    public PropertyFileWatcher(File file) {
        this.file = file;
    }

    public Properties getProperties() throws IOException {
        Properties p = new Properties();
        if (this.file.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.file);
                p.load(is);
                this.lastModified = this.file.lastModified();
                this.lastCheck = System.currentTimeMillis();
                this.stale = false;
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return p;
    }

    public boolean isStale() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheck > 1000L) {
            this.lastCheck = now;
            this.stale = this.file.exists() && this.file.lastModified() > this.lastModified;
        }
        return this.stale;
    }
}

