/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAccessRule
implements Comparable<ServiceAccessRule>,
Serializable {
    public static final String ANY = "*";
    public static ServiceAccessRule READ_ALL = new ServiceAccessRule("*", "*", new String[0]);
    public static ServiceAccessRule WRITE_ALL = new ServiceAccessRule("*", "*", new String[0]);
    String service;
    String method;
    Set<String> roles;

    public ServiceAccessRule(String service, String method, Set<String> roles) {
        this.service = service;
        this.method = method;
        this.roles = roles == null ? new HashSet<String>() : new HashSet<String>(roles);
    }

    public ServiceAccessRule(String service, String method, String ... roles) {
        this(service, method, (Set<String>)(roles == null ? null : new HashSet<String>(Arrays.asList(roles))));
    }

    public ServiceAccessRule(ServiceAccessRule other) {
        this.service = other.service;
        this.method = other.method;
        this.roles = new HashSet<String>(other.roles);
    }

    public ServiceAccessRule() {
        this(ANY, ANY, new String[0]);
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String layer) {
        this.method = layer;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String getKey() {
        return String.valueOf(this.service) + "." + this.method;
    }

    public String getValue() {
        if (this.roles.isEmpty()) {
            return ANY;
        }
        StringBuffer sb = new StringBuffer();
        for (String role : this.roles) {
            sb.append(role);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public int compareTo(ServiceAccessRule other) {
        int compareService = this.compareServiceItems(this.service, other.service);
        if (compareService != 0) {
            return compareService;
        }
        return this.compareServiceItems(this.method, other.method);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceAccessRule)) {
            return false;
        }
        return this.compareTo((ServiceAccessRule)obj) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.service).append((Object)this.method).toHashCode();
    }

    public int compareServiceItems(String item, String otherItem) {
        if (item.equals(otherItem)) {
            return 0;
        }
        if (ANY.equals(item)) {
            return -1;
        }
        if (ANY.equals(otherItem)) {
            return 1;
        }
        return item.compareTo(otherItem);
    }

    public String toString() {
        return String.valueOf(this.getKey()) + "=" + this.getValue();
    }
}

