/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.util.HashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;

public class ProjectionPolicyTest
extends GeoServerTestSupport {
    static WKTReader WKT = new WKTReader();

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("srsHandling", ProjectionPolicy.FORCE_DECLARED);
        props.put("srs", 4269);
        dataDirectory.addWellKnownType(MockData.BASIC_POLYGONS, props);
        props.put("srsHandling", ProjectionPolicy.REPROJECT_TO_DECLARED);
        props.put("srs", 4326);
        dataDirectory.addWellKnownType(MockData.POLYGONS, props);
        props.put("srsHandling", ProjectionPolicy.NONE);
        props.put("srs", 3004);
        dataDirectory.addWellKnownType(MockData.LINES, props);
        props.put("srsHandling", ProjectionPolicy.REPROJECT_TO_DECLARED);
        props.put("srs", 4326);
        props.put("alias", "MyPoints");
        dataDirectory.addWellKnownType(MockData.POINTS, props);
        dataDirectory.addWcs10Coverages();
    }

    public void testForce() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.BASIC_POLYGONS.getLocalPart());
        ProjectionPolicyTest.assertEquals((String)"EPSG:4269", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.FORCE_DECLARED, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4269"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4269"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    public void testReproject() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.POLYGONS.getLocalPart());
        ProjectionPolicyTest.assertEquals((String)"EPSG:4326", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.REPROJECT_TO_DECLARED, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        Geometry g = (Geometry)f.getDefaultGeometryProperty().getValue();
        ProjectionPolicyTest.assertFalse((boolean)g.equalsExact(WKT.read("POLYGON((500225 500025,500225 500075,500275 500050,500275 500025,500225 500025))")));
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    public void testLeaveNative() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.LINES.getLocalPart());
        ProjectionPolicyTest.assertEquals((String)"EPSG:3004", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.NONE, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:32615"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        Geometry g = (Geometry)f.getDefaultGeometryProperty().getValue();
        ProjectionPolicyTest.assertTrue((boolean)g.equalsExact(WKT.read("LINESTRING(500125 500025,500175 500075)")));
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:32615"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    public void testWithRename() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("MyPoints");
        ProjectionPolicyTest.assertEquals((String)"EPSG:4326", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.REPROJECT_TO_DECLARED, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        Geometry g = (Geometry)f.getDefaultGeometryProperty().getValue();
        ProjectionPolicyTest.assertFalse((boolean)g.equalsExact(WKT.read("POINT(500050 500050)")));
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    public void testForceCoverage() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName("usa");
        ci.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        ci.setSRS("EPSG:3857");
        catalog.save((ResourceInfo)ci);
        ci = catalog.getCoverageByName("usa");
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.FORCE_DECLARED, (Object)ci.getProjectionPolicy());
        ProjectionPolicyTest.assertEquals((String)"EPSG:3857", (String)ci.getSRS());
        AbstractGridCoverage2DReader r = (AbstractGridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
        ProjectionPolicyTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3857"), (Object)r.getCrs()));
        r = (AbstractGridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ProjectionPolicyTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3857"), (Object)r.getCrs()));
        CoverageStoreInfo store = catalog.getCoverageStoreByName("usa");
        ResourcePool rpool = catalog.getResourcePool();
        r = (AbstractGridCoverage2DReader)rpool.getGridCoverageReader(store, GeoTools.getDefaultHints());
        ProjectionPolicyTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)r.getCrs()));
    }
}

