/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.vfny.geoserver.global.xml.WriterHelper;

public class WriterHelperTest
extends TestCase {
    private ByteArrayOutputStream bos;
    private WriterHelper helper;

    protected void setUp() throws Exception {
        this.bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(this.bos);
        this.helper = new WriterHelper((Writer)writer);
    }

    public void testNoEscape() throws Exception {
        this.helper.textTag("title", "$%()");
        String result = this.bos.toString();
        WriterHelperTest.assertEquals((String)"<title>$%()</title>\n", (String)result);
    }

    public void testEscapePlain() throws Exception {
        this.helper.textTag("title", "Test < > & ' \"");
        String result = this.bos.toString();
        WriterHelperTest.assertEquals((String)"<title>Test &lt; &gt; &amp; &apos; &quot;</title>\n", (String)result);
    }

    public void testEscapeNewlines() throws Exception {
        this.helper.textTag("title", "<\n>\n");
        String result = this.bos.toString();
        WriterHelperTest.assertEquals((String)"<title>&lt;\n&gt;\n</title>\n", (String)result);
    }
}

