/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.springframework.security.SpringSecurityException;

public class ReadOnlyDataStoreTest
extends SecureObjectsTest {
    private DataStore ds;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureStore fs = (SimpleFeatureStore)EasyMock.createNiceMock(SimpleFeatureStore.class);
        EasyMock.expect((Object)((SimpleFeatureType)fs.getSchema())).andReturn((Object)DataUtilities.createType((String)"test", (String)"g:Polygon,name:String")).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        this.ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.expect((Object)this.ds.getFeatureSource("blah")).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{this.ds});
    }

    public void testDisallowedAPI() throws Exception {
        ReadOnlyDataStore ro = new ReadOnlyDataStore(this.ds, WrapperPolicy.hide(null));
        try {
            ro.createSchema(null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriterAppend("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testChallenge() throws Exception {
        ReadOnlyDataStore ro = new ReadOnlyDataStore(this.ds, WrapperPolicy.readOnlyChallenge(null));
        try {
            ro.createSchema(null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriterAppend("states", Transaction.AUTO_COMMIT);
            ReadOnlyDataStoreTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
    }
}

