/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFacade;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerLoaderProxy;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.DefaultGeoServerFacade;
import org.geoserver.config.impl.GeoServerFactoryImpl;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerImpl
implements GeoServer {
    private static final Logger LOGGER = Logging.getLogger(GeoServerImpl.class);
    GeoServerFactory factory = new GeoServerFactoryImpl(this);
    Catalog catalog;
    GeoServerFacade facade;
    List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();

    public GeoServerImpl() {
        this.facade = new DefaultGeoServerFacade(this);
    }

    @Override
    public GeoServerFacade getFacade() {
        return this.facade;
    }

    public void setFacade(GeoServerFacade facade) {
        this.facade = facade;
        facade.setGeoServer(this);
    }

    @Override
    public GeoServerFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(GeoServerFactory factory) {
        this.factory = factory;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public GeoServerInfo getGlobal() {
        return this.facade.getGlobal();
    }

    @Override
    public void setGlobal(GeoServerInfo global) {
        this.facade.setGlobal(global);
        this.fireGlobalPostModified();
    }

    @Override
    public LoggingInfo getLogging() {
        return this.facade.getLogging();
    }

    @Override
    public void setLogging(LoggingInfo logging) {
        this.facade.setLogging(logging);
        this.fireLoggingPostModified();
    }

    @Override
    public void add(ServiceInfo service) {
        if (service.getId() == null) {
            throw new NullPointerException("service id must not be null");
        }
        if (this.facade.getService(service.getId(), ServiceInfo.class) != null) {
            throw new IllegalArgumentException("service with id '" + service.getId() + "' already exists");
        }
        this.facade.add(service);
        this.firePostServiceModified(service);
    }

    public static <T> T unwrap(T obj) {
        return DefaultGeoServerFacade.unwrap(obj);
    }

    @Override
    public <T extends ServiceInfo> T getService(Class<T> clazz) {
        return this.facade.getService(clazz);
    }

    @Override
    public <T extends ServiceInfo> T getService(String id, Class<T> clazz) {
        return this.facade.getService(id, clazz);
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, Class<T> clazz) {
        return this.facade.getServiceByName(name, clazz);
    }

    @Override
    public Collection<? extends ServiceInfo> getServices() {
        return this.facade.getServices();
    }

    @Override
    public void remove(ServiceInfo service) {
        this.facade.remove(service);
    }

    @Override
    public void save(GeoServerInfo geoServer) {
        this.facade.save(geoServer);
        this.fireGlobalPostModified();
    }

    @Override
    public void save(LoggingInfo logging) {
        this.facade.save(logging);
        this.fireLoggingPostModified();
    }

    void fireGlobalPostModified() {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handlePostGlobalChange(this.facade.getGlobal());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void fireGlobalModified(GeoServerInfo global, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleGlobalChange(global, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void fireLoggingModified(LoggingInfo logging, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleLoggingChange(logging, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void fireLoggingPostModified() {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handlePostLoggingChange(this.facade.getLogging());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void save(ServiceInfo service) {
        this.facade.save(service);
        this.firePostServiceModified(service);
    }

    @Override
    public void fireServiceModified(ServiceInfo service, List<String> changed, List oldValues, List newValues) {
        for (ConfigurationListener l : this.getListeners()) {
            try {
                l.handleServiceChange(service, changed, oldValues, newValues);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    void firePostServiceModified(ServiceInfo service) {
        for (ConfigurationListener l : this.listeners) {
            try {
                l.handlePostServiceChange(service);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error occurred processing a configuration change listener", e);
            }
        }
    }

    @Override
    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<ConfigurationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void dispose() {
        for (GeoServerLifecycleHandler handler : GeoServerExtensions.extensions(GeoServerLifecycleHandler.class)) {
            try {
                handler.onDispose();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during dispose", t);
            }
        }
        if (this.catalog != null) {
            this.catalog.dispose();
        }
        if (this.facade != null) {
            this.facade.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws Exception {
        this.reset();
        GeoServerLoaderProxy loader = (GeoServerLoaderProxy)GeoServerExtensions.bean(GeoServerLoaderProxy.class);
        Object object = GeoServer.CONFIGURATION_LOCK;
        synchronized (object) {
            this.getCatalog().getResourcePool().dispose();
            loader.reload();
        }
        for (GeoServerLifecycleHandler handler : GeoServerExtensions.extensions(GeoServerLifecycleHandler.class)) {
            try {
                handler.onReload();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during reload", t);
            }
        }
    }

    @Override
    public void reset() {
        this.catalog.getResourcePool().dispose();
        CRS.reset((String)"all");
        for (GeoServerLifecycleHandler handler : GeoServerExtensions.extensions(GeoServerLifecycleHandler.class)) {
            try {
                handler.onReset();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "A GeoServer lifecycle handler threw an exception during reset", t);
            }
        }
    }
}

