/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.vividsolutions.jts.geom.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.NameImpl;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CatalogBuilderTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup(new CatalogBuilderTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWellKnownCoverageTypes();
    }

    public void testFeatureTypeNoSRS() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.BRIDGES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.BRIDGES));
        CatalogBuilderTest.assertNull((Object)fti.getSRS());
        CatalogBuilderTest.assertNull((Object)fti.getNativeCRS());
        CatalogBuilderTest.assertNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
        cb.setupBounds((ResourceInfo)fti);
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)fti.getNativeBoundingBox().getCoordinateReferenceSystem());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
    }

    public void testFeatureType() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        CatalogBuilderTest.assertEquals((String)"EPSG:32615", (String)fti.getSRS());
        CatalogBuilderTest.assertEquals((Object)CRS.decode((String)"EPSG:32615", (boolean)true), (Object)fti.getCRS());
        CatalogBuilderTest.assertNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
        cb.setupBounds((ResourceInfo)fti);
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox().getCoordinateReferenceSystem());
        CatalogBuilderTest.assertNotNull((Object)fti.getLatLonBoundingBox());
    }

    public void testGeometryless() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.GEOMETRYLESS.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.GEOMETRYLESS));
        LayerInfo layer = cb.buildLayer(fti);
        cb.setupBounds((ResourceInfo)fti);
        CatalogBuilderTest.assertNull((Object)fti.getCRS());
        CatalogBuilderTest.assertTrue((boolean)fti.getNativeBoundingBox().isEmpty());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
        CatalogBuilderTest.assertNull((Object)layer.getDefaultStyle());
    }

    public void testCoverage() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart()));
        CoverageInfo fti = cb.buildCoverage();
        CatalogBuilderTest.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)fti.getCRS());
        CatalogBuilderTest.assertEquals((String)"EPSG:4326", (String)fti.getSRS());
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeCRS());
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)fti.getLatLonBoundingBox());
    }

    public void testEmptyBounds() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo fti = cat.getFeatureTypeByName(this.getLayerId(MockData.POINTS));
        CatalogBuilderTest.assertEquals(Point.class, (Object)fti.getFeatureType().getGeometryDescriptor().getType().getBinding());
        CatalogBuilderTest.assertEquals((int)1, (int)fti.getFeatureSource(null, null).getCount(Query.ALL));
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore(cat.getStoreByName(MockData.CGF_PREFIX, DataStoreInfo.class));
        FeatureTypeInfo built = cb.buildFeatureType(fti.getQualifiedName());
        cb.setupBounds((ResourceInfo)built);
        CatalogBuilderTest.assertTrue((built.getNativeBoundingBox().getWidth() > 0.0 ? 1 : 0) != 0);
        CatalogBuilderTest.assertTrue((built.getNativeBoundingBox().getHeight() > 0.0 ? 1 : 0) != 0);
    }

    public void testWMS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable(LOGGER)) {
            LOGGER.warning("Remote OWS tests disabled, skipping catalog builder wms tests");
            return;
        }
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities");
        cat.save((StoreInfo)wms);
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("topp:states");
        this.assertWMSLayer(wmsLayer);
        LayerInfo layer = cb.buildLayer(wmsLayer);
        CatalogBuilderTest.assertEquals((Object)LayerInfo.Type.WMS, (Object)layer.getType());
        wmsLayer = cat.getFactory().createWMSLayer();
        wmsLayer.setName("states");
        wmsLayer.setNativeName("topp:states");
        cb.initWMSLayer(wmsLayer);
        this.assertWMSLayer(wmsLayer);
    }

    void assertWMSLayer(WMSLayerInfo wmsLayer) throws Exception {
        CatalogBuilderTest.assertEquals((String)"states", (String)wmsLayer.getName());
        CatalogBuilderTest.assertEquals((String)"topp:states", (String)wmsLayer.getNativeName());
        CatalogBuilderTest.assertEquals((String)"EPSG:4326", (String)wmsLayer.getSRS());
        CatalogBuilderTest.assertEquals((String)"USA Population", (String)wmsLayer.getTitle());
        CatalogBuilderTest.assertEquals((String)"This is some census data on the states.", (String)wmsLayer.getAbstract());
        CatalogBuilderTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)wmsLayer.getNativeCRS());
        CatalogBuilderTest.assertNotNull((Object)wmsLayer.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)wmsLayer.getLatLonBoundingBox());
        CatalogBuilderTest.assertFalse((boolean)wmsLayer.getKeywords().isEmpty());
    }

    public void testLargeNDMosaic() throws Exception {
        File mosaic = new File("./target/largeMosaic");
        try {
            this.createTimeMosaic(mosaic, 1025);
            Catalog cat = this.getCatalog();
            CatalogBuilder cb = new CatalogBuilder(cat);
            CoverageStoreInfo store = cb.buildCoverageStore("largeMosaic");
            store.setURL(mosaic.getAbsolutePath());
            store.setType("ImageMosaic");
            cat.add((StoreInfo)store);
            cb.setStore((StoreInfo)store);
            CoverageInfo ci = cb.buildCoverage();
            cat.add((ResourceInfo)ci);
            cat.getResourcePool().dispose();
        }
        finally {
            if (mosaic.exists() && mosaic.isDirectory()) {
                FileUtils.deleteDirectory((File)mosaic);
            }
        }
    }

    public void testMosaicParameters() throws Exception {
        File mosaic = new File("./target/smallMosaic");
        try {
            this.createTimeMosaic(mosaic, 4);
            Catalog cat = this.getCatalog();
            CatalogBuilder cb = new CatalogBuilder(cat);
            CoverageStoreInfo store = cb.buildCoverageStore("smallMosaic");
            store.setURL(mosaic.getAbsolutePath());
            store.setType("ImageMosaic");
            cat.add((StoreInfo)store);
            cb.setStore((StoreInfo)store);
            CoverageInfo ci = cb.buildCoverage();
            cat.add((ResourceInfo)ci);
            System.out.println(ci.getParameters());
            CatalogBuilderTest.assertEquals((Object)String.valueOf(-1), ci.getParameters().get(ImageMosaicFormat.MAX_ALLOWED_TILES.getName().toString()));
            CatalogBuilderTest.assertEquals((Object)"", ci.getParameters().get(ImageMosaicFormat.FILTER.getName().toString()));
            cat.getResourcePool().dispose();
        }
        finally {
            if (mosaic.exists() && mosaic.isDirectory()) {
                FileUtils.deleteDirectory((File)mosaic);
            }
        }
    }

    private void createTimeMosaic(File mosaic, int fileCount) throws IOException, FileNotFoundException {
        if (mosaic.exists()) {
            if (mosaic.isDirectory()) {
                FileUtils.deleteDirectory((File)mosaic);
            } else {
                mosaic.delete();
            }
        }
        mosaic.mkdir();
        GridCoverageFactory factory = new GridCoverageFactory();
        BufferedImage bi = new BufferedImage(10, 10, 6);
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D test = factory.create((CharSequence)"test", (RenderedImage)bi, (Envelope)envelope);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GeoTiffWriter writer = new GeoTiffWriter((Object)bos);
        writer.write((GridCoverage)test, null);
        byte[] bytes = bos.toByteArray();
        int i = 0;
        while (i < fileCount) {
            String pad = "";
            if (i < 10) {
                pad = "000";
            } else if (i < 100) {
                pad = "00";
            } else if (i < 1000) {
                pad = "0";
            }
            File target = new File(mosaic, "tile_" + pad + i + ".tiff");
            FileUtils.writeByteArrayToFile((File)target, (byte[])bytes);
            ++i;
        }
        Properties p = new Properties();
        p.put("ElevationAttribute", "elevation");
        p.put("Schema", "*the_geom:Polygon,location:String,elevation:Integer");
        p.put("PropertyCollectors", "IntegerFileNameExtractorSPI[elevationregex](elevation)");
        FileOutputStream fos = new FileOutputStream(new File(mosaic, "indexer.properties"));
        p.store(fos, null);
        fos.close();
        p.clear();
        p.put("regex", "(?<=_)(\\d{4})");
        fos = new FileOutputStream(new File(mosaic, "elevationregex.properties"));
        p.store(fos, null);
        fos.close();
    }

    public void testLookupSRSDetached() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        DataStoreInfo sf = cat.getDataStoreByName("sf");
        FeatureSource fs = sf.getDataStore(null).getFeatureSource(this.toName(MockData.PRIMITIVEGEOFEATURE));
        FeatureTypeInfo ft = cat.getFactory().createFeatureType();
        ft.setNativeName("PrimitiveGeoFeature");
        CatalogBuilderTest.assertNull((Object)ft.getSRS());
        CatalogBuilderTest.assertNull((Object)ft.getCRS());
        cb.lookupSRS(ft, fs, true);
        CatalogBuilderTest.assertNotNull((Object)ft.getSRS());
        CatalogBuilderTest.assertNotNull((Object)ft.getCRS());
    }

    public void testSetupBoundsDetached() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        DataStoreInfo sf = cat.getDataStoreByName("sf");
        FeatureSource fs = sf.getDataStore(null).getFeatureSource(this.toName(MockData.PRIMITIVEGEOFEATURE));
        FeatureTypeInfo ft = cat.getFactory().createFeatureType();
        ft.setNativeName("PrimitiveGeoFeature");
        CatalogBuilderTest.assertNull((Object)ft.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)ft.getLatLonBoundingBox());
        cb.lookupSRS(ft, fs, true);
        cb.setupBounds(ft, fs);
        CatalogBuilderTest.assertNotNull((Object)ft.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)ft.getLatLonBoundingBox());
    }

    public void testMetadataFromFeatueSource() throws Exception {
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        cb.setStore((StoreInfo)cb.buildDataStore("fooStore"));
        FeatureType ft = (FeatureType)EasyMock.createMock(FeatureType.class);
        EasyMock.expect((Object)ft.getName()).andReturn((Object)new NameImpl("foo")).anyTimes();
        EasyMock.expect((Object)ft.getCoordinateReferenceSystem()).andReturn(null).anyTimes();
        EasyMock.expect((Object)ft.getGeometryDescriptor()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{ft});
        org.geotools.data.ResourceInfo rInfo = (org.geotools.data.ResourceInfo)EasyMock.createMock(org.geotools.data.ResourceInfo.class);
        EasyMock.expect((Object)rInfo.getTitle()).andReturn((Object)"foo title");
        EasyMock.expect((Object)rInfo.getDescription()).andReturn((Object)"foo description");
        EasyMock.expect((Object)rInfo.getKeywords()).andReturn(new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz", ""))).anyTimes();
        EasyMock.replay((Object[])new Object[]{rInfo});
        FeatureSource fs = (FeatureSource)EasyMock.createMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)fs.getInfo()).andReturn((Object)rInfo).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        FeatureTypeInfo ftInfo = cb.buildFeatureType(fs);
        CatalogBuilderTest.assertEquals((String)"foo title", (String)ftInfo.getTitle());
        CatalogBuilderTest.assertEquals((String)"foo description", (String)ftInfo.getDescription());
        CatalogBuilderTest.assertTrue((boolean)ftInfo.getKeywords().contains(new Keyword("foo")));
        CatalogBuilderTest.assertTrue((boolean)ftInfo.getKeywords().contains(new Keyword("bar")));
        CatalogBuilderTest.assertTrue((boolean)ftInfo.getKeywords().contains(new Keyword("baz")));
    }

    Name toName(QName qname) {
        return new NameImpl(qname.getNamespaceURI(), qname.getLocalPart());
    }
}

