/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Element;

public class LegacyServicesReader {
    Element serverConfiguration;
    Map<String, Object> global;
    Map<String, Object> contact;
    Map<String, Object> wfs;
    Map<String, Object> wms;
    Map<String, Object> wcs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(file));
        try {
            this.serverConfiguration = ReaderUtils.parse(reader);
            this.global = null;
            this.contact = null;
            this.wfs = null;
            this.wms = null;
            this.wcs = null;
        }
        finally {
            reader.close();
        }
    }

    public Map<String, Object> global() throws Exception {
        if (this.global != null) {
            return this.global;
        }
        Element globalElement = ReaderUtils.getChildElement(this.serverConfiguration, "global");
        this.global = new HashMap<String, Object>();
        this.value("verbose", globalElement, this.global, Boolean.class);
        this.value("verboseExceptions", globalElement, this.global, Boolean.class);
        this.value("charSet", globalElement, this.global, String.class);
        this.text("updateSequence", globalElement, this.global, Integer.class, false, 0);
        this.text("log4jConfigFile", globalElement, this.global, String.class, false, "DEFAULT_LOGGING.properties");
        this.text("logLocation", globalElement, this.global, String.class, false, "logs/geoserver.log");
        this.value("suppressStdOutLogging", globalElement, this.global, Boolean.class, false, Boolean.FALSE);
        this.value("maxFeatures", globalElement, this.global, Integer.class);
        this.value("numDecimals", globalElement, this.global, Integer.class);
        this.text("onlineResource", globalElement, this.global, String.class, false, "http://geoserver.org");
        this.text("ProxyBaseUrl", globalElement, this.global, String.class);
        try {
            this.value("JaiMemoryCapacity", globalElement, this.global, Integer.class);
            Integer jmc = (Integer)this.global.get("JaiMemoryCapacity");
            if (jmc != null) {
                double d = (long)jmc.intValue() / Runtime.getRuntime().maxMemory();
                d = d > 1.0 ? 1.0 : d;
                this.global.put("JaiMemoryCapacity", d);
            }
        }
        catch (Exception e) {
            this.value("JaiMemoryCapacity", globalElement, this.global, Double.class);
        }
        this.value("JaiMemoryThreshold", globalElement, this.global, Double.class);
        this.value("JaiTileThreads", globalElement, this.global, Integer.class);
        this.value("JaiTilePriority", globalElement, this.global, Integer.class);
        this.value("JaiRecycling", globalElement, this.global, Boolean.class);
        this.value("ImageIOCache", globalElement, this.global, Boolean.class);
        this.value("JaiJPEGNative", globalElement, this.global, Boolean.class);
        this.value("JaiPNGNative", globalElement, this.global, Boolean.class);
        return this.global;
    }

    public Map<String, Object> contact() throws Exception {
        if (this.contact != null) {
            return this.contact;
        }
        Element globalElement = ReaderUtils.getChildElement(this.serverConfiguration, "global");
        this.contact = new HashMap<String, Object>();
        Element contactElement = ReaderUtils.getChildElement(globalElement, "ContactInformation");
        if (contactElement != null) {
            Element personPrimaryElement = ReaderUtils.getChildElement(contactElement, "ContactPersonPrimary");
            if (personPrimaryElement != null) {
                this.text("ContactPerson", personPrimaryElement, this.contact, String.class);
                this.text("ContactOrganization", personPrimaryElement, this.contact, String.class);
            }
            this.text("ContactPosition", contactElement, this.contact, String.class);
            Element addressElement = ReaderUtils.getChildElement(contactElement, "ContactAddress");
            if (addressElement != null) {
                this.text("Address", addressElement, this.contact, String.class);
                this.text("AddressType", addressElement, this.contact, String.class);
                this.text("City", addressElement, this.contact, String.class);
                this.text("StateOrProvince", addressElement, this.contact, String.class);
                this.text("PostCode", addressElement, this.contact, String.class);
                this.text("Country", addressElement, this.contact, String.class);
            }
            this.text("ContactVoiceTelephone", contactElement, this.contact, String.class);
            this.text("ContactFacsimileTelephone", contactElement, this.contact, String.class);
            this.text("ContactElectronicMailAddress", contactElement, this.contact, String.class);
        }
        return this.contact;
    }

    public Map<String, Object> wfs() throws Exception {
        if (this.wfs != null) {
            return this.wfs;
        }
        Element servicesElement = ReaderUtils.getChildElement(this.serverConfiguration, "services", true);
        Element wfsElement = this.service(servicesElement, "WFS");
        this.wfs = this.readService(wfsElement);
        this.value("serviceLevel", wfsElement, this.wfs, Integer.class);
        this.value("srsXmlStyle", wfsElement, this.wfs, Boolean.class, false, Boolean.TRUE);
        this.value("featureBounding", wfsElement, this.wfs, Boolean.class, false, Boolean.FALSE);
        return this.wfs;
    }

    public Map<String, Object> wms() throws Exception {
        if (this.wms != null) {
            return this.wms;
        }
        Element servicesElement = ReaderUtils.getChildElement(this.serverConfiguration, "services", true);
        Element wmsElement = this.service(servicesElement, "WMS");
        this.wms = this.readService(wmsElement);
        this.text("globalWatermarking", wmsElement, this.wms, Boolean.class, false, Boolean.FALSE);
        this.text("globalWatermarkingURL", wmsElement, this.wms, String.class, false, null);
        this.text("globalWatermarkingTransparency", wmsElement, this.wms, Integer.class, false, 0);
        this.text("globalWatermarkingPosition", wmsElement, this.wms, Integer.class, false, 8);
        this.text("allowInterpolation", wmsElement, this.wms, String.class, false, "Nearest");
        this.text("svgRenderer", wmsElement, this.wms, String.class, false, "Batik");
        this.text("svgAntiAlias", wmsElement, this.wms, Boolean.class, false, Boolean.TRUE);
        this.text("maxBuffer", wmsElement, this.wms, Integer.class, false, 25);
        this.text("maxRequestMemory", wmsElement, this.wms, Integer.class, false, 0);
        this.text("maxRenderingTime", wmsElement, this.wms, Integer.class, false, 0);
        this.text("maxRenderingErrors", wmsElement, this.wms, Integer.class, false, 0);
        ArrayList baseMaps = new ArrayList();
        Element baseMapGroupsElement = ReaderUtils.getChildElement(wmsElement, "BaseMapGroups");
        if (baseMapGroupsElement != null) {
            Element[] baseMapGroupElements = ReaderUtils.getChildElements(baseMapGroupsElement, "BaseMapGroup");
            for (int i = 0; i < baseMapGroupElements.length; ++i) {
                Element baseMapGroupElement = baseMapGroupElements[i];
                HashMap<String, Object> baseMap = new HashMap<String, Object>();
                baseMap.put("baseMapTitle", ReaderUtils.getAttribute(baseMapGroupElement, "baseMapTitle", true));
                baseMap.put("baseMapLayers", Arrays.asList(ReaderUtils.getChildText(baseMapGroupElement, "baseMapLayers").split(",")));
                String baseMapStyles = ReaderUtils.getChildText(baseMapGroupElement, "baseMapStyles");
                if (baseMapStyles != null && !"".equals(baseMapStyles)) {
                    baseMapStyles = baseMapStyles.trim();
                    int j = -1;
                    int k = 0;
                    ArrayList<String> styles = new ArrayList<String>();
                    while ((j = baseMapStyles.indexOf(44, k)) != -1) {
                        styles.add(baseMapStyles.substring(k, j).trim());
                        k = j + 1;
                    }
                    if (baseMapStyles.endsWith(",")) {
                        styles.add("");
                    } else if (k < baseMapStyles.length() - 1) {
                        styles.add(baseMapStyles.substring(k).trim());
                    }
                    baseMap.put("baseMapStyles", styles);
                    baseMap.put("rawBaseMapStyles", baseMapStyles);
                } else {
                    baseMap.put("baseMapStyles", Collections.EMPTY_LIST);
                    baseMap.put("rawBaseMapStyles", "");
                }
                Element baseMapEnvelopeElement = ReaderUtils.getChildElement(baseMapGroupElement, "baseMapEnvelope");
                if (baseMapEnvelopeElement != null) {
                    Element[] posElements = ReaderUtils.getChildElements(baseMapEnvelopeElement, "pos");
                    double x1 = Double.parseDouble(posElements[0].getFirstChild().getNodeValue().split(" ")[0]);
                    double y1 = Double.parseDouble(posElements[0].getFirstChild().getNodeValue().split(" ")[1]);
                    double x2 = Double.parseDouble(posElements[1].getFirstChild().getNodeValue().split(" ")[0]);
                    double y2 = Double.parseDouble(posElements[1].getFirstChild().getNodeValue().split(" ")[1]);
                    String srs = ReaderUtils.getAttribute(baseMapEnvelopeElement, "srsName", false);
                    CoordinateReferenceSystem crs = srs != null ? CRS.decode((String)srs) : null;
                    baseMap.put("baseMapEnvelope", new ReferencedEnvelope(x1, x2, y1, y2, crs));
                }
                baseMaps.add(baseMap);
            }
        }
        this.wms.put("BaseMapGroups", baseMaps);
        return this.wms;
    }

    public Map<String, Object> wcs() throws Exception {
        if (this.wcs != null) {
            return this.wcs;
        }
        Element servicesElement = ReaderUtils.getChildElement(this.serverConfiguration, "services", true);
        Element wcsElement = this.service(servicesElement, "WCS");
        this.wcs = this.readService(wcsElement);
        return this.wcs;
    }

    Map<String, Object> readService(Element serviceElement) throws Exception {
        HashMap<String, Object> service = new HashMap<String, Object>();
        service.put("enabled", ReaderUtils.getBooleanAttribute(serviceElement, "enabled", false, true));
        this.text("name", serviceElement, service, String.class);
        this.text("title", serviceElement, service, String.class);
        this.text("abstract", serviceElement, service, String.class);
        Element mlElement = ReaderUtils.getChildElement(serviceElement, "metadataLink");
        if (mlElement != null) {
            HashMap<String, String> metadataLink = new HashMap<String, String>();
            metadataLink.put("about", ReaderUtils.getAttribute(mlElement, "about", false));
            metadataLink.put("type", ReaderUtils.getAttribute(mlElement, "type", false));
            metadataLink.put("metadataType", ReaderUtils.getAttribute(mlElement, "metadataType", false));
            service.put("metadataLink", metadataLink);
        }
        Element keywordsElement = ReaderUtils.getChildElement(serviceElement, "keywords");
        Element[] keywordElements = ReaderUtils.getChildElements(keywordsElement, "keyword");
        ArrayList<String> keywords = new ArrayList<String>();
        if (keywordElements != null) {
            for (int i = 0; i < keywordElements.length; ++i) {
                keywords.add(keywordElements[i].getFirstChild().getTextContent());
            }
        }
        service.put("keywords", keywords);
        this.text("onlineResource", serviceElement, service, String.class);
        this.text("fees", serviceElement, service, String.class);
        this.text("accessConstraints", serviceElement, service, String.class);
        this.text("SchemaBaseUrl", serviceElement, service, String.class, false, "http://schemas.opengis.net");
        this.value("srsXmlStyle", serviceElement, service, Boolean.class);
        this.value("serviceLevel", serviceElement, service, Integer.class);
        this.text("citeConformanceHacks", serviceElement, service, Boolean.class, false, Boolean.FALSE);
        this.text("maintainer", serviceElement, service, String.class);
        return service;
    }

    Element service(Element servicesElement, String id) throws Exception {
        Element[] serviceElements = ReaderUtils.getChildElements(servicesElement, "service");
        for (int i = 0; i < serviceElements.length; ++i) {
            String serviceId = ReaderUtils.getAttribute(serviceElements[i], "type", false);
            if (!id.equals(serviceId)) continue;
            return serviceElements[i];
        }
        throw new Exception("No service element: " + id);
    }

    void value(String parameter, Element element, Map map, Class clazz) throws Exception {
        this.value(parameter, element, map, clazz, false, null);
    }

    <T> void value(String parameter, Element element, Map map, Class<T> clazz, boolean man, T def) throws Exception {
        Element valueElement = ReaderUtils.getChildElement(element, parameter);
        if (valueElement == null) {
            if (man) {
                throw new RuntimeException("No such element: " + parameter);
            }
            map.put(parameter, def);
            return;
        }
        Object value = null;
        value = Boolean.class.equals(clazz) ? Boolean.valueOf(ReaderUtils.getBooleanAttribute(valueElement, "value", true, false)) : (Integer.class.equals(clazz) ? new Integer(ReaderUtils.getIntAttribute(valueElement, "value", true, -1)) : (Double.class.equals(clazz) ? new Double(ReaderUtils.getDoubleAttribute(valueElement, "value", true)) : ReaderUtils.getAttribute(valueElement, "value", true)));
        map.put(parameter, value);
    }

    void text(String parameter, Element element, Map map, Class clazz) throws Exception {
        this.text(parameter, element, map, clazz, false, null);
    }

    <T> void text(String parameter, Element element, Map map, Class<T> clazz, boolean man, T def) throws Exception {
        String text = ReaderUtils.getChildText(element, parameter);
        if (text == null) {
            if (man) {
                throw new RuntimeException("No such element: " + parameter);
            }
            map.put(parameter, def);
            return;
        }
        Object value = text;
        if (text != null) {
            if (Boolean.class.equals(clazz)) {
                value = Boolean.valueOf(text);
            } else if (Integer.class.equals(clazz)) {
                value = Integer.valueOf(text);
            } else if (Double.class.equals(clazz)) {
                value = Double.valueOf(text);
            }
        }
        map.put(parameter, value);
    }
}

