/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public class FeatureSourceUtils {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.feature");

    public static ReferencedEnvelope getBoundingBoxEnvelope(FeatureSource<? extends FeatureType, ? extends Feature> fs) throws IOException {
        ReferencedEnvelope ev = fs.getBounds();
        if (ev == null || ev.isNull()) {
            try {
                ev = fs.getFeatures().getBounds();
            }
            catch (Throwable t) {
                LOGGER.log(Level.FINE, "Could not compute the data bounding box. Returning an empty envelope", t);
                ev = new ReferencedEnvelope(fs.getSchema().getCoordinateReferenceSystem());
            }
        }
        return ev;
    }
}

