/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.Iterator;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyFeatureCollection;
import org.geoserver.security.decorators.ReadOnlyFeatureIterator;
import org.geoserver.security.decorators.ReadOnlyFeatureLocking;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geoserver.security.decorators.ReadOnlyIterator;
import org.geoserver.security.decorators.SecuredObjectFactory;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;

public class DefaultSecureDataFactory
implements SecuredObjectFactory {
    @Override
    public boolean canSecure(Class clazz) {
        return DataAccess.class.isAssignableFrom(clazz) || DataStore.class.isAssignableFrom(clazz) || FeatureSource.class.isAssignableFrom(clazz) || FeatureStore.class.isAssignableFrom(clazz) || FeatureLocking.class.isAssignableFrom(clazz) || FeatureCollection.class.isAssignableFrom(clazz) || Iterator.class.isAssignableFrom(clazz) || FeatureIterator.class.isAssignableFrom(clazz);
    }

    @Override
    public Object secure(Object object, SecureCatalogImpl.WrapperPolicy policy) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!this.canSecure(clazz)) {
            throw new IllegalArgumentException("Don't know how to wrap objects of class " + object.getClass());
        }
        if (DataStore.class.isAssignableFrom(clazz)) {
            return new ReadOnlyDataStore((DataStore)object, policy);
        }
        if (DataAccess.class.isAssignableFrom(clazz)) {
            return new ReadOnlyDataAccess((DataAccess)object, policy);
        }
        if (FeatureSource.class.isAssignableFrom(clazz)) {
            if (policy.response != SecureCatalogImpl.Response.CHALLENGE) {
                return new ReadOnlyFeatureSource((FeatureSource)object, policy);
            }
            if (FeatureLocking.class.isAssignableFrom(clazz)) {
                return new ReadOnlyFeatureLocking((FeatureLocking)object, policy);
            }
            if (FeatureStore.class.isAssignableFrom(clazz)) {
                return new ReadOnlyFeatureStore((FeatureStore)object, policy);
            }
            if (FeatureSource.class.isAssignableFrom(clazz)) {
                return new ReadOnlyFeatureSource((FeatureSource)object, policy);
            }
        }
        if (FeatureCollection.class.isAssignableFrom(clazz)) {
            return new ReadOnlyFeatureCollection((FeatureCollection)object, policy);
        }
        if (Iterator.class.isAssignableFrom(clazz)) {
            return new ReadOnlyIterator((Iterator)object, policy);
        }
        if (FeatureIterator.class.isAssignableFrom(clazz)) {
            return new ReadOnlyFeatureIterator((FeatureIterator)object);
        }
        throw new IllegalArgumentException("Don't know how to wrap objects of class " + object.getClass());
    }

    public int getPriority() {
        return 100;
    }
}

