/* Copyright (c) 2001 - 2007 TOPP - www.openplans.org. All rights reserved.
 * This code is licensed under the GPL 2.0 license, available at the root
 * application directory.
 */
package org.geoserver.security.decorators;

import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.security.SecureCatalogImpl.WrapperPolicy;

public class SecuredLayerInfo extends DecoratingLayerInfo {

    WrapperPolicy policy;

    public SecuredLayerInfo(LayerInfo delegate, WrapperPolicy  policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public ResourceInfo getResource() {
        ResourceInfo r = super.getResource();
        if (r == null)
            return null;
        else if (r instanceof FeatureTypeInfo)
            return new SecuredFeatureTypeInfo((FeatureTypeInfo) r, policy);
        else if (r instanceof CoverageInfo)
            return new SecuredCoverageInfo((CoverageInfo) r, policy);
        else
            throw new RuntimeException("Don't know how to make resource of type " + r.getClass());
    }

}
