/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.test.GeoServerTestSupport;

public class CustomManglerTest
extends GeoServerTestSupport {
    private static final String BASEURL = "http://localhost:8080/geoserver";

    @Override
    protected String[] getSpringContextLocations() {
        return new String[]{"classpath*:/applicationContext.xml", "classpath*:/applicationSecurityContext.xml", "classpath*:/customManglerContext.xml"};
    }

    public void testBasic() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        CustomManglerTest.assertEquals((String)"http://localhost:8080/geoserver/test?here=iam", (String)url);
    }

    public void testKVP() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", Collections.singletonMap("param", "value()"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        CustomManglerTest.assertEquals((String)"http://localhost:8080/geoserver/test?param=value%28%29&here=iam", (String)url);
    }
}

