/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import java.io.IOException;
import java.io.InputStream;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.data.DataUtilities;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoServerTemplateLoader2Test
extends GeoServerTestSupport {
    GeoServerDataDirectory dd;
    Catalog cat;
    GeoServerTemplateLoader tl;

    @Override
    protected boolean useLegacyDataDirectory() {
        return false;
    }

    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dd = this.getDataDirectory();
        this.cat = this.getCatalog();
        this.tl = new GeoServerTemplateLoader(((Object)((Object)this)).getClass(), this.getResourceLoader());
    }

    public void testRelativeToFeatureType() throws IOException {
        Object source = this.tl.findTemplateSource("dummy.ftl");
        GeoServerTemplateLoader2Test.assertNull((Object)source);
        FeatureTypeInfo ft = this.cat.getFeatureTypeByName("PrimitiveGeoFeature");
        this.dd.copyToResourceDir((ResourceInfo)ft, this.template(), "dummy.ftl");
        this.tl.setFeatureType(ft);
        source = this.tl.findTemplateSource("dummy.ftl");
        GeoServerTemplateLoader2Test.assertNotNull((Object)source);
    }

    public void testRelativeToStore() throws IOException {
        GeoServerTemplateLoader2Test.assertNull((Object)this.tl.findTemplateSource("dummy.ftl"));
        FeatureTypeInfo ft = this.cat.getFeatureTypeByName("PrimitiveGeoFeature");
        this.tl.setFeatureType(ft);
        GeoServerTemplateLoader2Test.assertNull((Object)this.tl.findTemplateSource("dummy.ftl"));
        this.dd.copyToStoreDir((StoreInfo)ft.getStore(), this.template(), "dummy.ftl");
        GeoServerTemplateLoader2Test.assertNotNull((Object)this.tl.findTemplateSource("dummy.ftl"));
    }

    public void testRelativeToWorkspace() throws IOException {
        GeoServerTemplateLoader2Test.assertNull((Object)this.tl.findTemplateSource("dummy.ftl"));
        FeatureTypeInfo ft = this.cat.getFeatureTypeByName("PrimitiveGeoFeature");
        this.tl.setFeatureType(ft);
        GeoServerTemplateLoader2Test.assertNull((Object)this.tl.findTemplateSource("dummy.ftl"));
        this.dd.copyToWorkspaceDir(ft.getStore().getWorkspace(), this.template(), "dummy.ftl");
        GeoServerTemplateLoader2Test.assertNotNull((Object)this.tl.findTemplateSource("dummy.ftl"));
    }

    public void testRemoteType() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"remoteType", (String)"the_geom:MultiPolygon,FID:String,ADDRESS:String");
        this.tl.setFeatureType(ft);
        this.tl.findTemplateSource("header.ftl");
    }

    InputStream template() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("dummy.ftl.disabled");
    }
}

