/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerPersister;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.test.GeoServerTestSupport;
import org.w3c.dom.Document;

public class GeoServerPersisterTest
extends GeoServerTestSupport {
    Catalog catalog;

    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.catalog = this.getCatalog();
        GeoServerPersister p = new GeoServerPersister(this.getResourceLoader(), (XStreamPersister)new XStreamPersister.XML());
        this.catalog.addListener((CatalogListener)p);
    }

    public void testAddWorkspace() throws Exception {
        File ws = new File(testData.getDataDirectoryRoot(), "workspaces/acme");
        GeoServerPersisterTest.assertFalse((boolean)ws.exists());
        WorkspaceInfo acme = this.catalog.getFactory().createWorkspace();
        acme.setName("acme");
        this.catalog.add(acme);
        GeoServerPersisterTest.assertTrue((boolean)ws.exists());
    }

    public void testRemoveWorkspace() throws Exception {
        this.testAddWorkspace();
        File ws = new File(testData.getDataDirectoryRoot(), "workspaces/acme");
        GeoServerPersisterTest.assertTrue((boolean)ws.exists());
        WorkspaceInfo acme = this.catalog.getWorkspaceByName("acme");
        this.catalog.remove(acme);
        GeoServerPersisterTest.assertFalse((boolean)ws.exists());
    }

    public void testAddDataStore() throws Exception {
        this.testAddWorkspace();
        File dir = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        GeoServerPersisterTest.assertFalse((boolean)dir.exists());
        DataStoreInfo ds = this.catalog.getFactory().createDataStore();
        ds.setName("foostore");
        ds.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)ds);
        GeoServerPersisterTest.assertTrue((boolean)dir.exists());
        GeoServerPersisterTest.assertTrue((boolean)new File(dir, "datastore.xml").exists());
    }

    public void testModifyDataStore() throws Exception {
        this.testAddDataStore();
        DataStoreInfo ds = this.catalog.getDataStoreByName("acme", "foostore");
        GeoServerPersisterTest.assertTrue((boolean)ds.getConnectionParameters().isEmpty());
        ds.getConnectionParameters().put("foo", "bar");
        this.catalog.save((StoreInfo)ds);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/datastore.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathExists((String)"/dataStore/connectionParameters/entry[@key='foo']", (Document)dom);
    }

    public void testChangeDataStoreWorkspace() throws Exception {
        this.testAddDataStore();
        File f1 = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/datastore.xml");
        GeoServerPersisterTest.assertTrue((boolean)f1.exists());
        WorkspaceInfo nws = this.catalog.getFactory().createWorkspace();
        nws.setName("topp");
        this.catalog.add(nws);
        DataStoreInfo ds = this.catalog.getDataStoreByName("acme", "foostore");
        ds.setWorkspace(nws);
        this.catalog.save((StoreInfo)ds);
        GeoServerPersisterTest.assertFalse((boolean)f1.exists());
        File f2 = new File(testData.getDataDirectoryRoot(), "workspaces/topp/foostore/datastore.xml");
        GeoServerPersisterTest.assertTrue((boolean)f2.exists());
    }

    public void testRemoveDataStore() throws Exception {
        this.testAddDataStore();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
        DataStoreInfo ds = this.catalog.getDataStoreByName("acme", "foostore");
        this.catalog.remove((StoreInfo)ds);
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
    }

    public void testAddFeatureType() throws Exception {
        this.testAddDataStore();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        GeoServerPersisterTest.assertFalse((boolean)d.exists());
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("bar");
        ns.setURI("http://bar");
        this.catalog.add(ns);
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setName("foo");
        ft.setNamespace(ns);
        ft.setStore((StoreInfo)this.catalog.getDataStoreByName("acme", "foostore"));
        this.catalog.add((ResourceInfo)ft);
        GeoServerPersisterTest.assertTrue((boolean)d.exists());
    }

    public void testModifyFeatureType() throws Exception {
        this.testAddFeatureType();
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("bar", "foo");
        ft.setTitle("fooTitle");
        this.catalog.save((ResourceInfo)ft);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/featuretype.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"fooTitle", (String)"/featureType/title", (Document)dom);
    }

    public void testRemoveFeatureType() throws Exception {
        this.testAddFeatureType();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        GeoServerPersisterTest.assertTrue((boolean)d.exists());
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName("bar", "foo");
        this.catalog.remove((ResourceInfo)ft);
        GeoServerPersisterTest.assertFalse((boolean)d.exists());
    }

    public void testAddCoverageStore() throws Exception {
        this.testAddWorkspace();
        File dir = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        GeoServerPersisterTest.assertFalse((boolean)dir.exists());
        CoverageStoreInfo cs = this.catalog.getFactory().createCoverageStore();
        cs.setName("foostore");
        cs.setWorkspace(this.catalog.getWorkspaceByName("acme"));
        this.catalog.add((StoreInfo)cs);
        GeoServerPersisterTest.assertTrue((boolean)dir.exists());
        GeoServerPersisterTest.assertTrue((boolean)new File(dir, "coveragestore.xml").exists());
    }

    public void testModifyCoverageStore() throws Exception {
        this.testAddCoverageStore();
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("acme", "foostore");
        GeoServerPersisterTest.assertNull((Object)cs.getURL());
        cs.setURL("file:data/foo.tiff");
        this.catalog.save((StoreInfo)cs);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/coveragestore.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"file:data/foo.tiff", (String)"/coverageStore/url/text()", (Document)dom);
    }

    public void testRemoveCoverageStore() throws Exception {
        this.testAddCoverageStore();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore");
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("acme", "foostore");
        this.catalog.remove((StoreInfo)cs);
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
    }

    public void testAddCoverage() throws Exception {
        this.testAddCoverageStore();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        GeoServerPersisterTest.assertFalse((boolean)d.exists());
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("bar");
        ns.setURI("http://bar");
        this.catalog.add(ns);
        CoverageInfo ft = this.catalog.getFactory().createCoverage();
        ft.setName("foo");
        ft.setNamespace(ns);
        ft.setStore((StoreInfo)this.catalog.getCoverageStoreByName("acme", "foostore"));
        this.catalog.add((ResourceInfo)ft);
        GeoServerPersisterTest.assertTrue((boolean)d.exists());
    }

    public void testModifyCoverage() throws Exception {
        this.testAddCoverage();
        CoverageInfo ft = this.catalog.getCoverageByName("bar", "foo");
        ft.setTitle("fooTitle");
        this.catalog.save((ResourceInfo)ft);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/coverage.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"fooTitle", (String)"/coverage/title", (Document)dom);
    }

    public void testRemoveCoverage() throws Exception {
        this.testAddCoverage();
        File d = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo");
        GeoServerPersisterTest.assertTrue((boolean)d.exists());
        CoverageInfo ft = this.catalog.getCoverageByName("bar", "foo");
        this.catalog.remove((ResourceInfo)ft);
        GeoServerPersisterTest.assertFalse((boolean)d.exists());
    }

    public void testAddLayer() throws Exception {
        this.testAddFeatureType();
        this.testAddStyle();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/layer.xml");
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
        LayerInfo l = this.catalog.getFactory().createLayer();
        l.setResource((ResourceInfo)this.catalog.getFeatureTypeByName("bar", "foo"));
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        l.setDefaultStyle(s);
        this.catalog.add(l);
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
    }

    public void testModifyLayer() throws Exception {
        this.testAddLayer();
        LayerInfo l = this.catalog.getLayerByName("foo");
        l.setPath("/foo/bar");
        this.catalog.save(l);
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/layer.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"/foo/bar", (String)"/layer/path", (Document)dom);
    }

    public void testRemoveLayer() throws Exception {
        this.testAddLayer();
        File f = new File(testData.getDataDirectoryRoot(), "workspaces/acme/foostore/foo/layer.xml");
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
        LayerInfo l = this.catalog.getLayerByName("foo");
        this.catalog.remove(l);
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
    }

    public void testAddStyle() throws Exception {
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("foostyle");
        s.setFilename("foostyle.sld");
        this.catalog.add(s);
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
    }

    public void testModifyStyle() throws Exception {
        this.testAddStyle();
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        s.setFilename("foostyle2.sld");
        this.catalog.save(s);
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"foostyle2.sld", (String)"/style/filename", (Document)dom);
    }

    public void testRemoveStyle() throws Exception {
        this.testAddStyle();
        File f = new File(testData.getDataDirectoryRoot(), "styles/foostyle.xml");
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
        StyleInfo s = this.catalog.getStyleByName("foostyle");
        this.catalog.remove(s);
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
    }

    public void testAddLayerGroup() throws Exception {
        this.testAddLayer();
        File f = new File(testData.getDataDirectoryRoot(), "layergroups/lg.xml");
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
        LayerGroupInfo lg = this.catalog.getFactory().createLayerGroup();
        lg.setName("lg");
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(this.catalog.getStyleByName("foostyle"));
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(null);
        lg.getLayers().add(this.catalog.getLayerByName("foo"));
        lg.getStyles().add(this.catalog.getStyleByName("foostyle"));
        this.catalog.add(lg);
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
    }

    public void testModifyLayerGroup() throws Exception {
        this.testAddLayerGroup();
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("lg");
        StyleInfo s = this.catalog.getFactory().createStyle();
        s.setName("foostyle2");
        s.setFilename("foostyle2.sld");
        this.catalog.add(s);
        lg.getStyles().set(0, s);
        this.catalog.save(lg);
        File f = new File(testData.getDataDirectoryRoot(), "layergroups/lg.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)s.getId(), (String)"/layerGroup/styles/style/id", (Document)dom);
    }

    public void testRemoveLayerGroup() throws Exception {
        this.testAddLayerGroup();
        File f = new File(testData.getDataDirectoryRoot(), "layergroups/lg.xml");
        GeoServerPersisterTest.assertTrue((boolean)f.exists());
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("lg");
        this.catalog.remove(lg);
        GeoServerPersisterTest.assertFalse((boolean)f.exists());
    }

    public void testModifyGlobal() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setTitle("ACME");
        this.getGeoServer().save(global);
        File f = new File(testData.getDataDirectoryRoot(), "global.xml");
        Document dom = this.dom(f);
        XMLAssert.assertXpathEvaluatesTo((String)"ACME", (String)"/global/title", (Document)dom);
    }

    Document dom(File f) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
    }
}

