/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.platform.GeoServerResourceLoader;

public abstract class XStreamServiceLoader<T extends ServiceInfo>
implements ServiceLoader<T> {
    GeoServerResourceLoader resourceLoader;
    String filenameBase;

    public XStreamServiceLoader(GeoServerResourceLoader resourceLoader, String filenameBase) {
        this.resourceLoader = resourceLoader;
        this.filenameBase = filenameBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T load(GeoServer gs) throws Exception {
        String filename = this.filenameBase + ".xml";
        File file = this.resourceLoader.find(filename);
        if (file != null && file.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                XStreamPersister.XML xp = new XStreamPersister.XML();
                this.initXStreamPersister(xp, gs);
                ServiceInfo serviceInfo = this.initialize((ServiceInfo)xp.load(in, this.getServiceClass()));
                return (T)serviceInfo;
            }
            finally {
                in.close();
            }
        }
        T service = this.createServiceFromScratch(gs);
        return this.initialize(service);
    }

    protected T initialize(T service) {
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(T service, GeoServer gs) throws Exception {
        String filename = this.filenameBase + ".xml";
        File file = this.resourceLoader.find(filename);
        if (file == null) {
            file = this.resourceLoader.createFile(filename);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XStreamPersister.XML xp = new XStreamPersister.XML();
            this.initXStreamPersister(xp, gs);
            xp.save(service, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        xp.setGeoServer(gs);
        xp.getXStream().alias(this.filenameBase, this.getServiceClass());
    }

    protected abstract T createServiceFromScratch(GeoServer var1);
}

