/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.logging.LegacyLoggingImporter;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.CommonsLoggerFactory;
import org.geotools.util.logging.Log4JLoggerFactory;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class LoggingStartupContextListener
implements ServletContextListener {
    private static Logger LOGGER;

    public void contextDestroyed(ServletContextEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        block15: {
            ServletContext context = event.getServletContext();
            LoggingUtils.GeoToolsLoggingRedirection logging = LoggingUtils.GeoToolsLoggingRedirection.findValue(GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ServletContext)context));
            try {
                if (logging != LoggingUtils.GeoToolsLoggingRedirection.JavaLogging) {
                    if (logging == LoggingUtils.GeoToolsLoggingRedirection.CommonsLogging) {
                        Logging.ALL.setLoggerFactory((LoggerFactory)CommonsLoggerFactory.getInstance());
                    } else {
                        Logging.ALL.setLoggerFactory((LoggerFactory)Log4JLoggerFactory.getInstance());
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Could not configure log4j logging redirection", e);
            }
            String relinquishLoggingControl = GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ServletContext)context);
            if (Boolean.valueOf(relinquishLoggingControl).booleanValue()) {
                this.getLogger().info("RELINQUISH_LOG4J_CONTROL on, won't attempt to reconfigure LOG4J loggers");
            } else {
                try {
                    File baseDir = new File(GeoserverDataDirectory.findGeoServerDataDir(context));
                    GeoServerResourceLoader loader = new GeoServerResourceLoader(baseDir);
                    File f = loader.find("logging.xml");
                    if (f != null) {
                        XStreamPersister.XML xp = new XStreamPersister.XML();
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                        try {
                            LoggingInfo loginfo = xp.load(in, LoggingInfo.class);
                            LoggingUtils.initLogging(loader, loginfo.getLevel(), !loginfo.isStdOutLogging(), loginfo.getLocation());
                            break block15;
                        }
                        finally {
                            in.close();
                        }
                    }
                    f = loader.find("services.xml");
                    if (f != null) {
                        LegacyLoggingImporter loggingImporter = new LegacyLoggingImporter();
                        loggingImporter.imprt(baseDir);
                        LoggingUtils.initLogging(loader, loggingImporter.getConfigFileName(), loggingImporter.getSuppressStdOutLogging(), loggingImporter.getLogFile());
                    } else {
                        this.getLogger().log(Level.WARNING, "Could not find configuration file for logging");
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Could not configure log4j overrides", e);
                }
            }
        }
    }

    Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getLogger((String)"org.geoserver.logging");
        }
        return LOGGER;
    }
}

