/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.security.ServiceAccessRule;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class ServiceAccessRuleDAO {
    static final Logger LOGGER = Logging.getLogger(ServiceAccessRuleDAO.class);
    Catalog rawCatalog;
    TreeSet<ServiceAccessRule> rules;
    PropertyFileWatcher watcher;
    long lastModified;
    File securityDir;

    public static ServiceAccessRuleDAO get() {
        return (ServiceAccessRuleDAO)GeoServerExtensions.bean(ServiceAccessRuleDAO.class);
    }

    public ServiceAccessRuleDAO(Catalog rawCatalog) throws ConfigurationException {
        this.rawCatalog = rawCatalog;
        this.securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
    }

    public ServiceAccessRuleDAO() throws ConfigurationException {
        this.securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
    }

    ServiceAccessRuleDAO(Catalog rawCatalog, File securityDir) throws ConfigurationException {
        this.securityDir = securityDir;
    }

    public List<ServiceAccessRule> getRules() {
        this.checkPropertyFile(false);
        return new ArrayList<ServiceAccessRule>(this.rules);
    }

    public boolean addRule(ServiceAccessRule rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.add(rule);
    }

    public void reload() {
        this.checkPropertyFile(true);
    }

    public void clear() {
        this.rules.clear();
        this.lastModified = System.currentTimeMillis();
    }

    public boolean removeRule(ServiceAccessRule rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.remove(rule);
    }

    public void storeRules() throws IOException {
        FileOutputStream os = null;
        try {
            Properties p = this.toProperties();
            File propFile = new File(this.securityDir, "service.properties");
            os = new FileOutputStream(propFile);
            p.store(os, null);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException("Could not write updated data access rules to file system").initCause(e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    void checkPropertyFile(boolean force) {
        try {
            if (this.rules == null) {
                if (this.securityDir == null || !this.securityDir.exists()) {
                    this.rules = new TreeSet();
                } else {
                    File layers = new File(this.securityDir, "service.properties");
                    if (!layers.exists()) {
                        this.rules = new TreeSet();
                    } else {
                        this.watcher = new PropertyFileWatcher(layers);
                        this.loadRules(this.watcher.getProperties());
                    }
                }
                this.lastModified = System.currentTimeMillis();
            } else if (this.watcher != null && (this.watcher.isStale() || force)) {
                this.loadRules(this.watcher.getProperties());
                this.lastModified = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to reload data access rules from layers.properties, keeping old rules", e);
        }
    }

    void loadRules(Properties props) {
        TreeSet<ServiceAccessRule> result = new TreeSet<ServiceAccessRule>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String ruleValue;
            String ruleKey = (String)entry.getKey();
            ServiceAccessRule rule = this.parseServiceAccessRule(ruleKey, ruleValue = (String)entry.getValue());
            if (rule == null) continue;
            if (result.contains(rule)) {
                LOGGER.warning("Rule " + ruleKey + "." + ruleValue + " overwrites another rule on the same path");
            }
            result.add(rule);
        }
        if (result.size() == 0) {
            result.add(new ServiceAccessRule(new ServiceAccessRule()));
        }
        this.rules = result;
    }

    ServiceAccessRule parseServiceAccessRule(String ruleKey, String ruleValue) {
        String rule = ruleKey + "=" + ruleValue;
        String[] elements = this.parseElements(ruleKey);
        if (elements.length != 2) {
            LOGGER.warning("Invalid rule " + rule + ", the expected format is service.method=role1,role2,...");
            return null;
        }
        String service = elements[0];
        String method = elements[1];
        Set<String> roles = this.parseRoles(ruleValue);
        if ("*".equals(service) && !"*".equals(method)) {
            LOGGER.warning("Invalid rule " + rule + ", when namespace " + "is * then also layer must be *. Skipping rule " + rule);
            return null;
        }
        return new ServiceAccessRule(service, method, roles);
    }

    Properties toProperties() {
        Properties props = new Properties();
        for (ServiceAccessRule rule : this.rules) {
            props.put(rule.getKey(), rule.getValue());
        }
        return props;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!"*".equals(role)) continue;
            return Collections.singleton("*");
        }
        return roles;
    }

    private String[] parseElements(String path) {
        return path.split("\\s*\\.\\s*");
    }
}

