/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.Collection;
import java.util.Iterator;
import org.geoserver.catalog.Wrapper;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class ReadOnlyFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    SecureCatalogImpl.WrapperPolicy policy;

    ReadOnlyFeatureCollection(FeatureCollection<T, F> delegate, SecureCatalogImpl.WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public Iterator iterator() {
        return (Iterator)SecuredObjects.secure(this.delegate.iterator(), this.policy);
    }

    public FeatureIterator<F> features() {
        return (FeatureIterator)SecuredObjects.secure(this.delegate.features(), this.policy);
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        FeatureCollection fc = this.delegate.sort(order);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        FeatureCollection fc = this.delegate.subCollection(filter);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    public void close(FeatureIterator<F> close) {
        if (close instanceof Wrapper && ((Wrapper)close).isWrapperFor(FeatureIterator.class)) {
            this.delegate.close(((Wrapper)close).unwrap(FeatureIterator.class));
        } else {
            this.delegate.close(close);
        }
    }

    public void close(Iterator<F> close) {
        if (close instanceof Wrapper && ((Wrapper)((Object)close)).isWrapperFor(Iterator.class)) {
            this.delegate.close(((Wrapper)((Object)close)).unwrap(Iterator.class));
        } else {
            this.delegate.close(close);
        }
    }

    public boolean add(F o) {
        throw this.unsupportedOperation();
    }

    public boolean addAll(Collection c) {
        throw this.unsupportedOperation();
    }

    public void clear() {
        throw this.unsupportedOperation();
    }

    public boolean remove(Object o) {
        throw this.unsupportedOperation();
    }

    public boolean removeAll(Collection c) {
        throw this.unsupportedOperation();
    }

    public boolean retainAll(Collection c) {
        throw this.unsupportedOperation();
    }

    RuntimeException unsupportedOperation() {
        String typeName = this.getID();
        if (this.policy.response == SecureCatalogImpl.Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess(typeName);
        }
        return new UnsupportedOperationException("Feature type " + typeName + " is read only");
    }
}

