/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class ReadOnlyFeatureSource<T extends FeatureType, F extends Feature>
extends DecoratingFeatureSource<T, F> {
    SecureCatalogImpl.WrapperPolicy policy;

    protected ReadOnlyFeatureSource(FeatureSource<T, F> delegate, SecureCatalogImpl.WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public DataAccess<T, F> getDataStore() {
        DataAccess store = ((FeatureSource)this.delegate).getDataStore();
        if (store == null) {
            return null;
        }
        return (DataAccess)SecuredObjects.secure(store, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures() throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures();
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Filter filter) throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(filter);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(query);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }
}

