/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.List;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class ReadOnlyFeatureStore<T extends FeatureType, F extends Feature>
extends ReadOnlyFeatureSource<T, F>
implements FeatureStore<T, F> {
    public ReadOnlyFeatureStore(FeatureStore delegate, SecureCatalogImpl.WrapperPolicy policy) {
        super(delegate, policy);
    }

    public List<FeatureId> addFeatures(FeatureCollection<T, F> collection) throws IOException {
        throw this.unsupportedOperation();
    }

    public Transaction getTransaction() {
        return null;
    }

    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        throw this.unsupportedOperation();
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        throw this.unsupportedOperation();
    }

    public void removeFeatures(Filter filter) throws IOException {
        throw this.unsupportedOperation();
    }

    public void setFeatures(FeatureReader<T, F> reader) throws IOException {
        throw this.unsupportedOperation();
    }

    public void setTransaction(Transaction transaction) {
        throw this.unsupportedOperation();
    }

    protected RuntimeException unsupportedOperation() {
        String typeName = this.getSchema().getName().getLocalPart();
        if (this.policy.response == SecureCatalogImpl.Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess(typeName);
        }
        return new UnsupportedOperationException(typeName + " is read only");
    }
}

