/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FormatOptionsKvpParser
extends KvpParser
implements ApplicationContextAware {
    ApplicationContext applicationContext;

    public FormatOptionsKvpParser() {
        this("format_options");
    }

    public FormatOptionsKvpParser(String key) {
        super(key, Map.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object parse(String value) throws Exception {
        List parsers = GeoServerExtensions.extensions(KvpParser.class, (ApplicationContext)this.applicationContext);
        CaseInsensitiveMap formatOptions = new CaseInsensitiveMap(new HashMap());
        List<String> kvps = KvpUtils.escapedTokens(value, ';');
        for (String kvp : kvps) {
            List<String> kv = KvpUtils.escapedTokens(kvp, ':');
            if (kv.size() > 2) {
                throw new IllegalArgumentException("Invalid key-value pair length (" + kv.size() + " elements).");
            }
            String key = kv.get(0);
            String raw = kv.size() == 1 ? "true" : KvpUtils.unescape(kv.get(1));
            Object parsed = null;
            for (KvpParser parser : parsers) {
                if (key.equalsIgnoreCase(parser.getKey()) && (parsed = parser.parse(raw)) != null) break;
            }
            if (parsed == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Could not find kvp parser for: '" + key + "'. Storing as raw string.");
                }
                parsed = raw;
            }
            formatOptions.put(key, parsed);
        }
        return formatOptions;
    }
}

