/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.util.SoftValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwsUtils {
    static Map<Class, ClassProperties> classPropertiesCache = new SoftValueHashMap();

    public static void set(Object object, String property, Object value) throws IllegalArgumentException {
        Method s = OwsUtils.setter(object.getClass(), property, value != null ? value.getClass() : null);
        if (s == null) {
            throw new IllegalArgumentException("No such property '" + property + "' for object " + object);
        }
        try {
            s.invoke(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static ClassProperties classProperties(Class clazz) {
        ClassProperties properties = classPropertiesCache.get(clazz);
        if (properties == null) {
            properties = new ClassProperties(clazz);
            classPropertiesCache.put(clazz, properties);
        }
        return properties;
    }

    public static ClassProperties getClassProperties(Class clazz) {
        return OwsUtils.classProperties(clazz);
    }

    public static Method setter(Class clazz, String property, Class type) {
        return OwsUtils.classProperties(clazz).setter(property, type);
    }

    public static boolean has(Object object, String property) {
        return OwsUtils.getter(object.getClass(), property, null) != null;
    }

    public static Object get(Object object, String property) {
        Method g = OwsUtils.getter(object.getClass(), property, null);
        if (g == null) {
            throw new IllegalArgumentException("No such property '" + property + "' for object " + object);
        }
        try {
            return g.invoke(object, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getter(Class clazz, String property, Class type) {
        return OwsUtils.classProperties(clazz).getter(property, type);
    }

    public static Object property(Object object, String property, Class type) {
        Method getter = OwsUtils.getter(object.getClass(), property, type);
        if (getter != null) {
            try {
                return getter.invoke(object, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method method(Class clazz, String name) {
        return OwsUtils.classProperties(clazz).method(name);
    }

    public static <T> T parameter(Object[] parameters, Class<T> type) {
        int i = 0;
        while (i < parameters.length) {
            Object parameter = parameters[i];
            if (parameter != null && type.isAssignableFrom(parameter.getClass())) {
                return (T)parameter;
            }
            ++i;
        }
        return null;
    }

    public static void dumpExceptionMessages(ServiceException e, StringBuffer s, boolean xmlEscape) {
        Object ex = e;
        while (true) {
            String message;
            Throwable cause = ex.getCause();
            String lastMessage = message = ex.getMessage();
            if (!"".equals(message)) {
                if (xmlEscape) {
                    s.append(ResponseUtils.encodeXML(message));
                } else {
                    s.append(message);
                }
                if (ex instanceof ServiceException) {
                    Iterator t = ex.getExceptionText().iterator();
                    while (t.hasNext()) {
                        s.append("\n");
                        String msg = (String)t.next();
                        if (lastMessage.equals(msg)) continue;
                        if (xmlEscape) {
                            s.append(ResponseUtils.encodeXML(msg));
                        } else {
                            s.append(t.next());
                        }
                        lastMessage = msg;
                    }
                }
                if (cause != null) {
                    s.append("\n");
                }
            }
            if (ex == cause || cause == null) break;
            ex = cause;
        }
    }

    public static <T> void copy(T source, T target, Class<T> clazz) {
        ClassProperties properties = OwsUtils.getClassProperties(clazz);
        for (String p : properties.properties()) {
            Class<?> type;
            Method setter;
            Method getter = properties.getter(p, null);
            if (getter == null || (setter = properties.setter(p, type = getter.getReturnType())) == null && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type)) continue;
            try {
                Object newValue = getter.invoke(source, null);
                if (newValue == null) continue;
                if (setter == null) {
                    if (Collection.class.isAssignableFrom(type)) {
                        OwsUtils.updateCollectionProperty(target, (Collection)newValue, getter);
                        continue;
                    }
                    if (!Map.class.isAssignableFrom(type)) continue;
                    OwsUtils.updateMapProperty(target, (Map)newValue, getter);
                    continue;
                }
                setter.invoke(target, newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void updateCollectionProperty(Object object, Collection newValue, Method getter) throws Exception {
        Collection oldValue = (Collection)getter.invoke(object, null);
        oldValue.clear();
        oldValue.addAll(newValue);
    }

    static void updateMapProperty(Object object, Map newValue, Method getter) throws Exception {
        Map oldValue = (Map)getter.invoke(object, null);
        oldValue.clear();
        oldValue.putAll(newValue);
    }
}

