/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.geoserver.ows.util.RequestObjectLogger;

public class EMFLogger
extends RequestObjectLogger {
    public EMFLogger(String logPackage) {
        super(logPackage);
    }

    protected boolean isRequestObject(Object obj) {
        return obj instanceof EObject;
    }

    protected void log(Object obj, int level, StringBuffer log) {
        EObject object = (EObject)obj;
        EList properties = object.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature property : properties) {
            Object value = object.eGet(property);
            if (value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty()) continue;
            log.append("\n");
            int i = 0;
            while (i < level) {
                log.append("    ");
                ++i;
            }
            if (value instanceof EObject && level < 3) {
                log.append(property.getName());
                log.append(":");
                this.log((EObject)value, level + 1, log);
                continue;
            }
            if (value instanceof Collection) {
                this.log(property.getName(), (Collection)value, level + 1, log);
                continue;
            }
            log.append(property.getName());
            log.append(" = " + value);
        }
    }

    protected void log(String property, Collection collection, int level, StringBuffer log) {
        int count = 0;
        for (Object o : collection) {
            String pc = String.valueOf(property) + "[" + count + "]";
            if (o instanceof EObject) {
                log.append(pc);
                log.append(":");
                this.log((EObject)o, level, log);
                continue;
            }
            if (o instanceof Collection) {
                this.log(pc, (Collection)o, level + 1, log);
                continue;
            }
            log.append(pc).append(" = " + o);
        }
    }
}

