/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geoserver.ows.util.EncodingInfo;
import org.geoserver.ows.util.RewindableInputStream;
import org.geoserver.ows.util.UCSReader;
import org.geotools.util.logging.Logging;

public class XmlCharsetDetector {
    protected static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests");
    private static final char RIGHT_ANGLE_BRACKET = '>';
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding\\s*\\=\\s*\"([^\"]+)\"");
    private static final int MAX_XMLDECL_SIZE = 100;

    public static Reader getCharsetAwareReader(InputStream istream, EncodingInfo encInfo) throws IOException, UnsupportedCharsetException {
        RewindableInputStream stream = new RewindableInputStream(istream, false);
        byte[] b4 = new byte[4];
        int count = 0;
        while (count < 4) {
            int b = stream.read();
            if (-1 == b) break;
            b4[count] = (byte)b;
            ++count;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("First 4 bytes of XML doc are : " + Integer.toHexString(b4[0] & 0xFF).toUpperCase() + " ('" + (char)b4[0] + "') " + Integer.toHexString(b4[1] & 0xFF).toUpperCase() + " ('" + (char)b4[1] + "') " + Integer.toHexString(b4[2] & 0xFF).toUpperCase() + " ('" + (char)b4[2] + "') " + Integer.toHexString(b4[3] & 0xFF).toUpperCase() + " ('" + (char)b4[3] + "')");
        }
        encInfo.copyFrom(XmlCharsetDetector.getEncodingName(b4, count));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Charset detection phase 1. Inferred encoding: " + encInfo.toString());
        }
        stream.reset();
        String ENCODING = encInfo.getEncoding().toUpperCase(Locale.ENGLISH);
        Boolean isBigEndian = encInfo.isBigEndian();
        boolean hasBOM = encInfo.hasBOM();
        if (hasBOM && ENCODING.equals("UTF-8")) {
            stream.skip(3L);
        }
        if (count > 1 && (ENCODING.equals("UTF-16LE") || ENCODING.equals("UTF-16BE"))) {
            int b0 = b4[0] & 0xFF;
            int b1 = b4[1] & 0xFF;
            if (b0 == 255 && b1 == 254 || b0 == 254 && b1 == 255) {
                stream.skip(2L);
            }
        }
        Reader reader = null;
        if ("ISO-10646-UCS-4".equals(ENCODING)) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                reader = isBE ? new UCSReader(stream, 8) : new UCSReader(stream, 4);
            } else {
                String s = "Unsupported byte order for ISO-10646-UCS-4 encoding.";
                throw new UnsupportedCharsetException(s);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader((InputStream)stream, ENCODING);
        }
        String declEncoding = XmlCharsetDetector.getXmlEncoding(reader);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Charset detection phase 2. Charset in XML declaration is `" + declEncoding + "`.");
        }
        stream.reset();
        stream.setChunkedMode(true);
        if (declEncoding != null && !declEncoding.equals(ENCODING) && !declEncoding.equals("ISO-10646-UCS-2")) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Declared charset differs from inferred one. Trying to construct InputStreamReader for `" + declEncoding + "`.");
            }
            reader = new InputStreamReader((InputStream)stream, declEncoding);
            encInfo.setEncoding(declEncoding);
        }
        return reader;
    }

    public static Reader getCharsetAwareReader(InputStream istream) throws IOException, UnsupportedCharsetException {
        return XmlCharsetDetector.getCharsetAwareReader(istream, new EncodingInfo());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Reader createReader(InputStream istream, EncodingInfo encInfo) throws IllegalArgumentException, UnsupportedEncodingException {
        void var4_11;
        String charset = encInfo.getEncoding();
        Boolean isBigEndian = encInfo.isBigEndian();
        if (charset == null) {
            String string = "Name of the charset must not be NULL!";
            throw new IllegalArgumentException(string);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to create reader basing on existing charset information: `" + encInfo + "`.");
        }
        Object var4_5 = null;
        if ("ISO-10646-UCS-4".equals(charset)) {
            if (isBigEndian == null) {
                String s = "Unsupported byte order for ISO-10646-UCS-4 encoding.";
                throw new UnsupportedEncodingException(s);
            }
            boolean isBE = isBigEndian;
            if (isBE) {
                UCSReader uCSReader = new UCSReader(istream, 8);
                return var4_11;
            }
            UCSReader uCSReader = new UCSReader(istream, 4);
            return var4_11;
        }
        if (!"ISO-10646-UCS-2".equals(charset)) {
            InputStreamReader inputStreamReader = new InputStreamReader(istream, charset);
            return var4_11;
        }
        if (isBigEndian == null) {
            String s = "Byte order must be specified for ISO-10646-UCS-2.";
            throw new UnsupportedEncodingException(s);
        }
        boolean isBE = isBigEndian;
        if (isBE) {
            UCSReader uCSReader = new UCSReader(istream, 8);
            return var4_11;
        }
        UCSReader uCSReader = new UCSReader(istream, 4);
        return var4_11;
    }

    public static EncodingInfo getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            return new EncodingInfo("UTF-8", null);
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return new EncodingInfo("UTF-16BE", new Boolean(true), true);
        }
        if (b0 == 255 && b1 == 254) {
            return new EncodingInfo("UTF-16LE", new Boolean(false), true);
        }
        if (count < 3) {
            return new EncodingInfo("UTF-8", null);
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return new EncodingInfo("UTF-8", null, true);
        }
        if (count < 4) {
            return new EncodingInfo("UTF-8", null);
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return new EncodingInfo("ISO-10646-UCS-4", new Boolean(true));
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return new EncodingInfo("ISO-10646-UCS-4", new Boolean(false));
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return new EncodingInfo("ISO-10646-UCS-4", null);
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return new EncodingInfo("ISO-10646-UCS-4", null);
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return new EncodingInfo("UTF-16BE", new Boolean(true));
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return new EncodingInfo("UTF-16LE", new Boolean(false));
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return new EncodingInfo("CP037", null);
        }
        return new EncodingInfo("UTF-8", null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getXmlEncoding(Reader reader) {
        try {
            sw = new StringWriter(100);
            count = 0;
            while (true) {
                block5: {
                    if (6 > count && -1 != (c = reader.read())) break block5;
                    if (6 > count || !"<?xml ".equals(sw.toString())) {
                        if (XmlCharsetDetector.LOGGER.isLoggable(Level.FINER) == false) return null;
                        XmlCharsetDetector.LOGGER.finer("Invalid(?) XML declaration: " + sw.toString() + ".");
                        return null;
                    }
                    ** GOTO lbl21
                }
                sw.write(c);
                ++count;
            }
        }
        catch (IOException e) {
            if (XmlCharsetDetector.LOGGER.isLoggable(Level.WARNING) == false) return null;
            XmlCharsetDetector.LOGGER.warning("Failed to extract charset info from XML declaration due to IOException: " + e.getMessage());
            return null;
        }
lbl-1000:
        // 1 sources

        {
            sw.write(c);
            ++count;
lbl21:
            // 2 sources

            ** while (100 > count && -1 != (c = reader.read()) && '>' != (char)c)
        }
lbl22:
        // 1 sources

        m = XmlCharsetDetector.ENCODING_PATTERN.matcher(sw.toString());
        if (m.find() == false) return null;
        return m.group(1);
    }
}

