/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.EncodingInfo;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.data.DataUtilities;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractURLPublisher
extends AbstractController {
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        URL url = this.getUrl(request);
        if (url == null) {
            response.sendError(404);
            return null;
        }
        File file = DataUtilities.urlToFile((URL)url);
        if (file != null && file.exists() && file.isDirectory()) {
            String uri = request.getRequestURI().toString();
            uri = String.valueOf(uri) + (uri.endsWith("/") ? "index.html" : "/index.html");
            response.addHeader("Location", uri);
            response.sendError(302);
            return null;
        }
        String mime = this.getServletContext().getMimeType(new File(url.getFile()).getName());
        if (mime != null) {
            response.setContentType(mime);
        }
        URLConnection connection = null;
        InputStream input = null;
        try {
            long lastModified;
            connection = url.openConnection();
            long length = connection.getContentLength();
            if (length > 0L && length <= Integer.MAX_VALUE) {
                response.setContentLength((int)length);
            }
            if ((lastModified = connection.getLastModified()) > 0L) {
                SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                String formatted = String.valueOf(format.format(new Date(lastModified))) + " GMT";
                response.setHeader("Last-Modified", formatted);
            }
            EncodingInfo encInfo = null;
            ServletOutputStream output = null;
            byte[] b4 = new byte[4];
            int count = 0;
            input = connection.getInputStream();
            count = input.read(b4);
            encInfo = XmlCharsetDetector.getEncodingName(b4, count);
            response.setCharacterEncoding(encInfo.getEncoding() != null ? encInfo.getEncoding() : "UTF-8");
            output = response.getOutputStream();
            output.write(b4, 0, count);
            byte[] buffer = new byte[8192];
            int n = -1;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return null;
    }

    protected abstract URL getUrl(HttpServletRequest var1) throws IOException;
}

