/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.DomainMetadataType;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.ows11.ExceptionType;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.ows11.RequestMethodType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.feature.NameImpl;
import org.geotools.xml.EMFUtils;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class Ows11Util {
    static Ows11Factory f = Ows11Factory.eINSTANCE;

    public static LanguageStringType languageString(InternationalString value) {
        return Ows11Util.languageString(value.toString(Locale.getDefault()));
    }

    public static LanguageStringType languageString(String value) {
        LanguageStringType ls = f.createLanguageStringType();
        ls.setValue(value);
        return ls;
    }

    public static KeywordsType keywords(List<String> keywords) {
        if (keywords == null || keywords.size() == 0) {
            return null;
        }
        KeywordsType kw = f.createKeywordsType();
        for (String keyword : keywords) {
            kw.getKeyword().add((Object)Ows11Util.languageString(keyword));
        }
        return kw;
    }

    public static CodeType code(String value) {
        CodeType code = f.createCodeType();
        code.setValue(value);
        return code;
    }

    public static CodeType code(Name name) {
        CodeType code = f.createCodeType();
        code.setValue(name.getURI());
        return code;
    }

    public static Name name(CodeType code) {
        if (code.getCodeSpace() != null) {
            return new NameImpl(code.getCodeSpace(), code.getValue());
        }
        String[] parsed = code.getValue().trim().split(":");
        if (parsed.length == 1) {
            return new NameImpl(parsed[0]);
        }
        return new NameImpl(parsed[0], parsed[1]);
    }

    public static CodeType code(CodeType value) {
        return Ows11Util.code(value.getValue());
    }

    public static DomainMetadataType type(String name) {
        DomainMetadataType type = f.createDomainMetadataType();
        type.setValue(name);
        return type;
    }

    public static ExceptionReportType exceptionReport(ServiceException exception, boolean verboseExceptions) {
        ExceptionType e = f.createExceptionType();
        if (exception.getCode() != null) {
            e.setExceptionCode(exception.getCode());
        } else {
            e.setExceptionCode("NoApplicableCode");
        }
        e.setLocator(exception.getLocator());
        StringBuffer sb = new StringBuffer();
        OwsUtils.dumpExceptionMessages(exception, sb, true);
        e.getExceptionText().add((Object)sb.toString());
        e.getExceptionText().addAll((Collection)exception.getExceptionText());
        if (verboseExceptions) {
            e.getExceptionText().add((Object)"Details:");
            ByteArrayOutputStream trace = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(trace));
            e.getExceptionText().add((Object)new String(trace.toByteArray()));
        }
        ExceptionReportType report = f.createExceptionReportType();
        report.setVersion("1.1.0");
        report.getException().add((Object)e);
        return report;
    }

    public static DCPType dcp(String service, String operation, EObject request) {
        String baseUrl = (String)EMFUtils.get((EObject)request, (String)"baseUrl");
        if (baseUrl == null) {
            throw new IllegalArgumentException("Request object" + request + " has no 'baseUrl' property.");
        }
        String href = baseUrl + "?service=" + service + "&request=" + operation + "&";
        DCPType dcp = f.createDCPType();
        dcp.setHTTP(f.createHTTPType());
        RequestMethodType get = f.createRequestMethodType();
        get.setHref(href);
        dcp.getHTTP().getGet().add((Object)get);
        RequestMethodType post = f.createRequestMethodType();
        post.setHref(baseUrl);
        dcp.getHTTP().getPost().add((Object)post);
        return dcp;
    }
}

