/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.IOException;
import java.io.InputStream;

public class RewindableInputStream
extends InputStream {
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    protected boolean fMayReadChunks;
    protected InputStream fInputStream;
    protected byte[] fData;
    protected int fStartOffset;
    protected int fEndOffset;
    protected int fOffset;
    protected int fLength;
    protected int fMark;

    public RewindableInputStream(InputStream is) {
        this(is, true, 64);
    }

    public RewindableInputStream(InputStream is, boolean chunkedMode) {
        this(is, chunkedMode, 64);
    }

    public RewindableInputStream(InputStream is, boolean chunkedMode, int initialSize) {
        if (0 >= initialSize) {
            initialSize = 64;
        }
        this.fData = new byte[initialSize];
        this.fInputStream = is;
        this.fStartOffset = 0;
        this.fMayReadChunks = chunkedMode;
        this.fEndOffset = -1;
        this.fOffset = 0;
        this.fLength = 0;
        this.fMark = 0;
    }

    public void setStartOffset(int offset) {
        this.fStartOffset = offset;
    }

    public void setChunkedMode(boolean chunkedMode) {
        this.fMayReadChunks = chunkedMode;
    }

    public void enableChunkedMode() {
        this.fMayReadChunks = true;
    }

    public void disableChunkedMode() {
        this.fMayReadChunks = false;
    }

    public void rewind() {
        this.fOffset = this.fStartOffset;
    }

    @Override
    public int read() throws IOException {
        int b = 0;
        if (this.fOffset < this.fLength) {
            return this.fData[this.fOffset++] & 0xFF;
        }
        if (this.fOffset == this.fEndOffset) {
            return -1;
        }
        if (this.fOffset == this.fData.length) {
            byte[] newData = new byte[this.fOffset << 1];
            System.arraycopy(this.fData, 0, newData, 0, this.fOffset);
            this.fData = newData;
        }
        if ((b = this.fInputStream.read()) == -1) {
            this.fEndOffset = this.fOffset;
            return -1;
        }
        this.fData[this.fLength++] = (byte)b;
        ++this.fOffset;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (null == b) {
            throw new NullPointerException("Destination byte array is null.");
        }
        if (0 == len) {
            return 0;
        }
        if (b.length < off || b.length < off + len || 0 > off || 0 > len) {
            throw new IndexOutOfBoundsException();
        }
        int bytesLeft = this.fLength - this.fOffset;
        if (bytesLeft == 0) {
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fMayReadChunks) {
                return this.fInputStream.read(b, off, len);
            }
            int returnedVal = this.read();
            if (returnedVal == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            b[off] = (byte)returnedVal;
            return 1;
        }
        if (this.fMayReadChunks) {
            int readFromBuffer = len < bytesLeft ? len : bytesLeft;
            System.arraycopy(this.fData, this.fOffset, b, off, readFromBuffer);
            int readFromStream = 0;
            if (len > bytesLeft) {
                readFromStream = this.fInputStream.read(b, off + bytesLeft, len - bytesLeft);
            }
            this.fOffset += readFromBuffer;
            return readFromBuffer + (-1 == readFromStream ? 0 : readFromStream);
        }
        if (len > bytesLeft) {
            len = bytesLeft;
        }
        System.arraycopy(this.fData, this.fOffset, b, off, len);
        this.fOffset += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int bytesLeft = this.fLength - this.fOffset;
        if (bytesLeft == 0) {
            if (this.fOffset == this.fEndOffset) {
                return 0L;
            }
            return this.fInputStream.skip(n);
        }
        if (n <= (long)bytesLeft) {
            this.fOffset = (int)((long)this.fOffset + n);
            return n;
        }
        this.fOffset += bytesLeft;
        if (this.fOffset == this.fEndOffset) {
            return bytesLeft;
        }
        return this.fInputStream.skip(n -= (long)bytesLeft) + (long)bytesLeft;
    }

    @Override
    public int available() throws IOException {
        int bytesLeft = this.fLength - this.fOffset;
        if (bytesLeft == 0) {
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            return this.fMayReadChunks ? this.fInputStream.available() : 0;
        }
        return bytesLeft;
    }

    @Override
    public void mark(int howMuch) {
        this.fMark = this.fOffset;
    }

    @Override
    public void reset() {
        this.fOffset = this.fMark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.fInputStream != null) {
            this.fInputStream.close();
            this.fInputStream = null;
            this.fData = null;
        }
    }
}

