/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");

    private ReaderUtils() {
    }

    public static Element parse(Reader xml) {
        Document doc;
        InputSource in = new InputSource(xml);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(false);
        dfactory.setValidating(false);
        dfactory.setIgnoringComments(true);
        dfactory.setCoalescing(true);
        dfactory.setIgnoringElementContentWhitespace(true);
        try {
            doc = dfactory.newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            String msg = "Error reading : " + xml;
            throw new RuntimeException(msg, e);
        }
        return doc.getDocumentElement();
    }

    public static File checkFile(File file, boolean isDir) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(isDir ? "Folder" : "File") + " does not exist: " + file);
        }
        if (isDir && !file.isDirectory()) {
            throw new FileNotFoundException("File exists but is not a directory:" + file);
        }
        if (!isDir && !file.isFile()) {
            throw new FileNotFoundException("File exists but is not a regular file:" + file);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("File is valid: ").append(file).toString());
        }
        return file;
    }

    public static Element[] getChildElements(Element root, String name) {
        try {
            return ReaderUtils.getChildElements(root, name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Element[] getChildElements(Element root, String name, boolean mandatory) throws Exception {
        ArrayList<Element> elements = new ArrayList<Element>();
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && name.equals(child.getNodeName())) {
                elements.add((Element)child);
            }
            child = child.getNextSibling();
        }
        if (mandatory && elements.isEmpty()) {
            throw new Exception(String.valueOf(root.getNodeName()) + " does not contains a child element named " + name);
        }
        return elements.toArray(new Element[0]);
    }

    public static Element getChildElement(Element root, String name, boolean mandatory) throws Exception {
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && name.equals(child.getNodeName())) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        if (mandatory && child == null) {
            throw new Exception(String.valueOf(root.getNodeName()) + " does not contains a child element named " + name);
        }
        return null;
    }

    public static Element getChildElement(Element root, String name) {
        try {
            return ReaderUtils.getChildElement(root, name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getIntAttribute(Element elem, String attName, boolean mandatory, int defaultValue) throws Exception {
        String attValue = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (!mandatory && attValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attValue);
        }
        catch (Exception ex) {
            if (mandatory) {
                throw new Exception(String.valueOf(attName) + " attribute of element " + elem.getNodeName() + " must be an integer, but it's '" + attValue + "'");
            }
            return defaultValue;
        }
    }

    public static String getAttribute(Element elem, String attName, boolean mandatory) throws Exception {
        if (elem == null) {
            if (mandatory) {
                throw new NullPointerException();
            }
            return "";
        }
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new Exception("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new Exception("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    public static boolean getBooleanAttribute(Element elem, String attName, boolean mandatory, boolean defaultValue) throws Exception {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (value == null || value == "") {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static String getChildText(Element root, String childName) {
        try {
            return ReaderUtils.getChildText(root, childName, false);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getChildText(Element root, String childName, boolean mandatory) throws Exception {
        Element elem = ReaderUtils.getChildElement(root, childName, mandatory);
        if (elem != null) {
            return ReaderUtils.getElementText(elem, mandatory);
        }
        if (mandatory) {
            String msg = "Mandatory child " + childName + "not found in " + " element: " + root;
            throw new Exception(msg);
        }
        return null;
    }

    public static String getElementText(Element elem) {
        try {
            return ReaderUtils.getElementText(elem, false);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getElementText(Element elem, boolean mandatory) throws Exception {
        String value = null;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("getting element text for ").append(elem).toString());
        }
        if (elem != null) {
            NodeList childs = elem.getChildNodes();
            int nChilds = childs.getLength();
            int i = 0;
            while (i < nChilds) {
                Node child = childs.item(i);
                if (child.getNodeType() == 3) {
                    value = child.getNodeValue();
                    if (!mandatory || !"".equals(value.trim())) break;
                    throw new Exception(String.valueOf(elem.getNodeName()) + " text is empty");
                }
                ++i;
            }
            if (mandatory && value == null) {
                throw new Exception(String.valueOf(elem.getNodeName()) + " element does not contains text");
            }
        } else {
            throw new Exception("Argument element can't be null");
        }
        return ReaderUtils.unescape(value);
    }

    public static List getKeyWords(Element keywordsElem) {
        if (keywordsElem == null) {
            return Collections.EMPTY_LIST;
        }
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        ArrayList<String> keywords = new ArrayList<String>(kCount);
        int i = 0;
        while (i < kCount) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText(kelem);
            if (kword != null) {
                keywords.add(kword);
            }
            ++i;
        }
        Object[] s = keywords.toArray();
        if (s == null) {
            return new ArrayList();
        }
        ArrayList<Object> ss = new ArrayList<Object>(s.length);
        int i2 = 0;
        while (i2 < s.length) {
            ss.add(s[i2]);
            ++i2;
        }
        return ss;
    }

    public static Element getFirstChildElement(Element root) {
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static double getDoubleAttribute(Element elem, String attName, boolean mandatory) throws Exception {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (value == null || value == "") {
            return 0.0;
        }
        double d = Double.NaN;
        try {
            d = Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("Illegal attribute value for " + attName + " in element " + elem.getNodeName() + ". Expected double, but was " + value);
        }
        return d;
    }

    public static void validate(Document xml, DefaultHandler errorHandler, String targetNamespace, String schemaLocation) {
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            tx.transform(new DOMSource(xml), new StreamResult(output));
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(output.toByteArray()));
            ReaderUtils.validate(reader, errorHandler, targetNamespace, schemaLocation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void validate(Reader xml, DefaultHandler errorHandler, String targetNamespace, String schemaLocation) {
        InputSource in = new InputSource(xml);
        try {
            SAXParserFactory sf = SAXParserFactory.newInstance();
            sf.setNamespaceAware(true);
            sf.setValidating(true);
            SAXParser parser = sf.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            if (schemaLocation != null) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaLocation);
            }
            parser.parse(in, errorHandler);
        }
        catch (Exception e) {
            String msg = "Error reading : " + xml;
            throw new RuntimeException(msg, e);
        }
    }

    private static String unescape(String text) {
        String s = text;
        if (s != null && s.matches(".*&(.*);.*")) {
            s = s.replaceAll("&quot;", "\"");
            s = s.replaceAll("&amp;", "&");
            s = s.replaceAll("&apos;", "'");
            s = s.replaceAll("&lt;", "<");
            s = s.replaceAll("&gt;", ">");
        }
        return s;
    }

    public static List<String> stringToList(String keywords, String delimiter) {
        if (keywords == null || keywords.length() == 0 || delimiter == null || delimiter.length() == 0 | keywords.indexOf(delimiter) < 0) {
            return Collections.emptyList();
        }
        ArrayList<String> elements = new ArrayList<String>();
        int index = -1;
        while ((index = keywords.indexOf(delimiter)) >= 0) {
            if (index > 0) {
                elements.add(keywords.substring(0, index));
            }
            keywords = keywords.substring(index);
        }
        if (keywords.length() > 0) {
            elements.add(keywords);
        }
        return elements;
    }
}

