/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.data.test.MockData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoverageStoreTest
extends CatalogRESTTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        dataDirectory.addWellKnownCoverageTypes();
    }

    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores.xml");
        CoverageStoreTest.assertEquals((int)this.catalog.getStoresByWorkspace("wcs", CoverageStoreInfo.class).size(), (int)dom.getElementsByTagName("coverageStore").getLength());
    }

    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/wcs/coveragestores.json");
        CoverageStoreTest.assertTrue((boolean)(json instanceof JSONObject));
        Object coveragestores = ((JSONObject)json).getJSONObject("coverageStores").get("coverageStore");
        CoverageStoreTest.assertNotNull((Object)coveragestores);
        if (coveragestores instanceof JSONArray) {
            CoverageStoreTest.assertEquals((int)this.catalog.getCoverageStoresByWorkspace("wcs").size(), (int)((JSONArray)coveragestores).size());
        } else {
            CoverageStoreTest.assertEquals((int)1, (int)this.catalog.getCoverageStoresByWorkspace("wcs").size());
        }
    }

    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores.html");
        List coveragestores = this.catalog.getCoverageStoresByWorkspace("wcs");
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        CoverageStoreTest.assertEquals((int)coveragestores.size(), (int)links.getLength());
        int i = 0;
        while (i < coveragestores.size()) {
            CoverageStoreInfo cs = (CoverageStoreInfo)coveragestores.get(i);
            Element link = (Element)links.item(i);
            CoverageStoreTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(cs.getName()) + ".html"));
            ++i;
        }
    }

    public void testPutAllUnauthorized() throws Exception {
        CoverageStoreTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces/wcs/coveragestores").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        CoverageStoreTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores").getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        CoverageStoreTest.assertEquals((String)"coverageStore", (String)dom.getDocumentElement().getNodeName());
        CoverageStoreTest.assertEquals((String)"BlueMarble", (String)this.xp.evaluate("/coverageStore/name", dom));
        CoverageStoreTest.assertEquals((String)"wcs", (String)this.xp.evaluate("/coverageStore/workspace/name", dom));
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.html");
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("wcs", "BlueMarble");
        List coverages = this.catalog.getCoveragesByCoverageStore(cs);
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        CoverageStoreTest.assertEquals((int)coverages.size(), (int)links.getLength());
        int i = 0;
        while (i < coverages.size()) {
            CoverageInfo ft = (CoverageInfo)coverages.get(i);
            Element link = (Element)links.item(i);
            CoverageStoreTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(ft.getName()) + ".html"));
            ++i;
        }
    }

    File setupNewCoverageStore() throws Exception {
        File dir = new File("./target/usa");
        dir.mkdir();
        dir.deleteOnExit();
        File f = new File(dir, "usa.prj");
        f.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(f);
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/usa.prj"), (OutputStream)fout);
        fout.flush();
        fout.close();
        f = new File(dir, "usa.meta");
        f.deleteOnExit();
        fout = new FileOutputStream(f);
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/usa.meta"), (OutputStream)fout);
        fout.flush();
        fout.close();
        f = new File(dir, "usa.png");
        f.deleteOnExit();
        fout = new FileOutputStream(f);
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/usa.png"), (OutputStream)fout);
        fout.flush();
        fout.close();
        return f;
    }

    public void testPostAsXML() throws Exception {
        File f = this.setupNewCoverageStore();
        String xml = "<coverageStore><name>newCoverageStore</name><type>WorldImage</type><url>file://" + f.getAbsolutePath() + "</url>" + "<workspace>wcs</workspace>" + "</coverageStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores", xml, "text/xml");
        CoverageStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        CoverageStoreTest.assertNotNull((Object)response.getHeader("Location"));
        CoverageStoreTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/wcs/coveragestores/newCoverageStore"));
        CoverageStoreInfo newCoverageStore = this.catalog.getCoverageStoreByName("newCoverageStore");
        CoverageStoreTest.assertNotNull((Object)newCoverageStore);
        CoverageStoreTest.assertNotNull((Object)newCoverageStore.getFormat());
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/wcs/coveragestores/BlueMarble.json");
        JSONObject coverageStore = ((JSONObject)json).getJSONObject("coverageStore");
        CoverageStoreTest.assertNotNull((Object)coverageStore);
        CoverageStoreTest.assertEquals((Object)"BlueMarble", (Object)coverageStore.get("name"));
        CoverageStoreTest.assertEquals((Object)"wcs", (Object)coverageStore.getJSONObject("workspace").get("name"));
        CoverageStoreTest.assertNotNull((Object)coverageStore.get("type"));
        CoverageStoreTest.assertNotNull((Object)coverageStore.get("url"));
    }

    public void testPostAsJSON() throws Exception {
        File f = this.setupNewCoverageStore();
        String json = "{'coverageStore':{'name':'newCoverageStore','type': 'WorldImage','url':'" + f.getAbsolutePath().replace('\\', '/') + "'," + "'workspace':'wcs'," + "}" + "}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores", json, "text/json");
        CoverageStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        CoverageStoreTest.assertNotNull((Object)response.getHeader("Location"));
        CoverageStoreTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/wcs/coveragestores/newCoverageStore"));
        CoverageStoreInfo newCoverageStore = this.catalog.getCoverageStoreByName("newCoverageStore");
        CoverageStoreTest.assertNotNull((Object)newCoverageStore);
        CoverageStoreTest.assertNotNull((Object)newCoverageStore.getFormat());
    }

    public void testPostToResource() throws Exception {
        String xml = "<coverageStore><name>BlueMarble</name><enabled>false</enabled></coverageStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        CoverageStoreTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/coverageStore/enabled", (Document)dom);
        String xml = "<coverageStore><name>BlueMarble</name><enabled>false</enabled></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        CoverageStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/coverageStore/enabled", (Document)dom);
        CoverageStoreTest.assertFalse((boolean)this.catalog.getCoverageStoreByName("wcs", "BlueMarble").isEnabled());
    }

    public void testPut2() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"GeoTIFF", (String)"/coverageStore/type", (Document)dom);
        String xml = "<coverageStore><name>BlueMarble</name><type>WorldImage</type></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        CoverageStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("wcs", "BlueMarble");
        CoverageStoreTest.assertEquals((String)"WorldImage", (String)cs.getType());
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<coverageStore><name>changed</name></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/nonExistant", xml, "text/xml");
        CoverageStoreTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testDeleteNonExistant() throws Exception {
        CoverageStoreTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/nonExistant").getStatusCode());
    }

    public void testDelete() throws Exception {
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName("wcs", "BlueMarble");
        List coverages = this.catalog.getCoveragesByCoverageStore(cs);
        for (CoverageInfo c : coverages) {
            for (LayerInfo l : this.catalog.getLayers((ResourceInfo)c)) {
                this.catalog.remove(l);
            }
            this.catalog.remove((ResourceInfo)c);
        }
        CoverageStoreTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble").getStatusCode());
        CoverageStoreTest.assertNull((Object)this.catalog.getCoverageStoreByName("wcs", "BlueMarble"));
    }

    public void testDeleteNonEmpty() throws Exception {
        CoverageStoreTest.assertEquals((int)401, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble").getStatusCode());
    }

    public void testDeleteRecursive() throws Exception {
        CoverageStoreTest.assertNotNull((Object)this.catalog.getCoverageStoreByName("wcs", "BlueMarble"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble?recurse=true");
        CoverageStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        CoverageStoreTest.assertNull((Object)this.catalog.getCoverageStoreByName("wcs", "BlueMarble"));
        for (CoverageInfo c : this.catalog.getCoverages()) {
            if (!c.getStore().getName().equals("BlueMarble")) continue;
            CoverageStoreTest.fail();
        }
    }
}

