/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.w3c.dom.Document;

public class LayerGroupTest
extends CatalogRESTTestSupport {
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        LayerGroupInfo lg = this.catalog.getFactory().createLayerGroup();
        lg.setName("sfLayerGroup");
        lg.getLayers().add(this.catalog.getLayerByName("sf:PrimitiveGeoFeature"));
        lg.getLayers().add(this.catalog.getLayerByName("sf:AggregateGeoFeature"));
        lg.getStyles().add(this.catalog.getStyleByName("point"));
        lg.getStyles().add(this.catalog.getStyleByName("point"));
        lg.setBounds(new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326")));
        this.catalog.add(lg);
    }

    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layergroups.xml");
        LayerGroupTest.assertEquals((int)this.catalog.getLayerGroups().size(), (int)dom.getElementsByTagName("layerGroup").getLength());
    }

    public void testGetAllAsHTML() throws Exception {
        this.getAsDOM("/rest/layergroups.html");
    }

    public void testGetAsXML() throws Exception {
        this.print(this.get("/rest/layergroups/sfLayerGroup.xml"));
        Document dom = this.getAsDOM("/rest/layergroups/sfLayerGroup.xml");
        LayerGroupTest.assertEquals((String)"layerGroup", (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"sfLayerGroup", (String)"/layerGroup/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//layer)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//style)", (Document)dom);
    }

    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/layergroups/sfLayerGroup.html");
    }

    public void testPost() throws Exception {
        String xml = "<layerGroup><name>newLayerGroup</name><layers><layer>Ponds</layer><layer>Forests</layer></layers><styles><style>polygon</style><style>point</style></styles></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        LayerGroupTest.assertEquals((int)201, (int)response.getStatusCode());
        LayerGroupTest.assertNotNull((Object)response.getHeader("Location"));
        LayerGroupTest.assertTrue((boolean)response.getHeader("Location").endsWith("/layergroups/newLayerGroup"));
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("newLayerGroup");
        LayerGroupTest.assertNotNull((Object)lg);
        LayerGroupTest.assertEquals((int)2, (int)lg.getLayers().size());
        LayerGroupTest.assertEquals((String)"Ponds", (String)((LayerInfo)lg.getLayers().get(0)).getName());
        LayerGroupTest.assertEquals((String)"Forests", (String)((LayerInfo)lg.getLayers().get(1)).getName());
        LayerGroupTest.assertEquals((int)2, (int)lg.getStyles().size());
        LayerGroupTest.assertEquals((String)"polygon", (String)((StyleInfo)lg.getStyles().get(0)).getName());
        LayerGroupTest.assertEquals((String)"point", (String)((StyleInfo)lg.getStyles().get(1)).getName());
        LayerGroupTest.assertNotNull((Object)lg.getBounds());
    }

    public void testPostNoStyles() throws Exception {
        String xml = "<layerGroup><name>newLayerGroup</name><layers><layer>Ponds</layer><layer>Forests</layer></layers></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        LayerGroupTest.assertEquals((int)201, (int)response.getStatusCode());
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("newLayerGroup");
        LayerGroupTest.assertNotNull((Object)lg);
        LayerGroupTest.assertEquals((int)2, (int)lg.getLayers().size());
        LayerGroupTest.assertEquals((String)"Ponds", (String)((LayerInfo)lg.getLayers().get(0)).getName());
        LayerGroupTest.assertEquals((String)"Forests", (String)((LayerInfo)lg.getLayers().get(1)).getName());
        LayerGroupTest.assertEquals((int)2, (int)lg.getStyles().size());
        LayerGroupTest.assertNull(lg.getStyles().get(0));
        LayerGroupTest.assertNull(lg.getStyles().get(1));
    }

    public void testPut() throws Exception {
        String xml = "<layerGroup><name>sfLayerGroup</name><styles><style>polygon</style><style>line</style></styles></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/sfLayerGroup", xml, "text/xml");
        LayerGroupTest.assertEquals((int)200, (int)response.getStatusCode());
        LayerGroupInfo lg = this.catalog.getLayerGroupByName("sfLayerGroup");
        LayerGroupTest.assertEquals((int)2, (int)lg.getLayers().size());
        LayerGroupTest.assertEquals((int)2, (int)lg.getStyles().size());
        LayerGroupTest.assertEquals((String)"polygon", (String)((StyleInfo)lg.getStyles().get(0)).getName());
        LayerGroupTest.assertEquals((String)"line", (String)((StyleInfo)lg.getStyles().get(1)).getName());
    }

    public void testDelete() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/layergroups/sfLayerGroup");
        LayerGroupTest.assertEquals((int)200, (int)response.getStatusCode());
        LayerGroupTest.assertEquals((int)0, (int)this.catalog.getLayerGroups().size());
    }
}

