/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.WCSCapsTransformer;

public class WCSCapabilitiesResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)WCSCapabilitiesResponse.class.getPackage().getName());
    private byte[] rawResponse;
    private ApplicationContext applicationContext;

    public WCSCapabilitiesResponse(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request request) throws ServiceException {
        GeoServerInfo gsInfo;
        int geoUS;
        if (!(request instanceof CapabilitiesRequest)) {
            throw new IllegalArgumentException("Not a GetCapabilities Request");
        }
        CapabilitiesRequest capreq = (CapabilitiesRequest)request;
        int reqUS = -1;
        if (capreq.getUpdateSequence() != null) {
            try {
                reqUS = Integer.parseInt(capreq.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = (gsInfo = request.getServiceConfig().getGeoServer().getGlobal()).getUpdateSequence())) {
            throw new WcsException("Client supplied an updateSequence that is greater than the current sever updateSequence", WcsException.WcsExceptionCode.InvalidUpdateSequence, "");
        }
        if (reqUS == geoUS) {
            throw new WcsException("WCS capabilities document is current (updateSequence = " + geoUS + ")", WcsException.WcsExceptionCode.CurrentUpdateSequence, "");
        }
        WCSCapsTransformer transformer = new WCSCapsTransformer(request.getBaseUrl(), this.applicationContext);
        transformer.setIndentation(2);
        transformer.setEncoding(Charset.forName(gsInfo.getCharset()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            transformer.transform(request, out);
        }
        catch (TransformerException e) {
            throw new WcsException(e);
        }
        this.rawResponse = out.toByteArray();
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("execute() not called or not succeed.");
        }
        return "text/xml; charset=" + gs.getGlobal().getCharset();
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return null;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("execute() not called or not succeed.");
        }
        out.write(this.rawResponse);
    }

    public void abort(ServiceInfo gs) {
    }
}

