/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import org.geoserver.ows.KvpParser;
import org.geoserver.wcs.kvp.GridType;
import org.vfny.geoserver.wcs.WcsException;

public class GridTypeKvpParser
extends KvpParser {
    public GridTypeKvpParser() {
        super("GridType", String.class);
    }

    public Object parse(String value) throws Exception {
        GridType type = null;
        GridType[] gridTypeArray = GridType.values();
        int n = gridTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridType currType = gridTypeArray[n2];
            if (currType.getXmlConstant().equalsIgnoreCase(value)) {
                type = currType;
                break;
            }
            ++n2;
        }
        if (type == null) {
            throw new WcsException("Could not understand grid type '" + value + "'", WcsException.WcsExceptionCode.InvalidParameterValue, "GridType");
        }
        if (type == GridType.GT2dGridIn3dCrs) {
            throw new WcsException("GeoServer does not support type " + type.name(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridType");
        }
        return type.getXmlConstant();
    }
}

