/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.util.Collection;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Resource;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.crs.TestResource;
import org.geotools.referencing.CRS;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class SRSDescriptionPage
extends GeoServerBasePage
implements IHeaderContributor {
    private String jsSrs;
    private String jsBbox;
    private double jsMaxResolution;

    public void renderHead(IHeaderResponse headerResponse) {
        String onLoadJsCall = "initMap('" + this.jsSrs + "', " + this.jsBbox + ", " + this.jsMaxResolution + ")";
        headerResponse.renderOnLoadJavascript(onLoadJsCall);
    }

    public SRSDescriptionPage(PageParameters params) {
        this.add((IBehavior)HeaderContributor.forCss((String)"openlayers/theme/default/style.css"));
        this.add((IBehavior)HeaderContributor.forJavaScript((String)"openlayers/OpenLayers.js"));
        Locale locale = this.getLocale();
        String code = params.getString("code");
        this.add((Component)new Label("code", code));
        String name = "";
        try {
            name = CRS.getAuthorityFactory((boolean)true).getDescriptionText(code).toString(this.getLocale());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.add((Component)new Label("crsName", name));
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)code);
        }
        catch (Exception e) {
            // empty catch block
        }
        InternationalString scope = null;
        InternationalString remarks = null;
        String wkt = "";
        String aovCoords = "";
        String areaOfValidity = "";
        this.jsBbox = "null";
        this.jsSrs = code;
        if (crs != null) {
            scope = crs.getScope();
            remarks = crs.getRemarks();
            wkt = crs.toString();
            Extent domainOfValidity = crs.getDomainOfValidity();
            if (domainOfValidity != null) {
                double maxres;
                String bbox;
                double[] dst2;
                double[] dst1;
                areaOfValidity = domainOfValidity.getDescription() == null ? "" : domainOfValidity.getDescription().toString(locale);
                Collection geographicElements = domainOfValidity.getGeographicElements();
                for (GeographicExtent ex : geographicElements) {
                    aovCoords = aovCoords + " " + ex;
                }
                GeographicBoundingBox box = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)crs);
                double westBoundLongitude = box.getWestBoundLongitude();
                double eastBoundLongitude = box.getEastBoundLongitude();
                double southBoundLatitude = box.getSouthBoundLatitude();
                double northBoundLatitude = box.getNorthBoundLatitude();
                try {
                    MathTransform tr = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326"), (CoordinateReferenceSystem)crs, (boolean)true);
                    dst1 = new double[tr.getTargetDimensions()];
                    dst2 = new double[tr.getTargetDimensions()];
                    double[] src1 = new double[tr.getSourceDimensions()];
                    src1[0] = westBoundLongitude;
                    src1[1] = southBoundLatitude;
                    double[] src2 = new double[tr.getSourceDimensions()];
                    src2[0] = eastBoundLongitude;
                    src2[1] = northBoundLatitude;
                    tr.transform(src1, 0, dst1, 0, 1);
                    tr.transform(src2, 0, dst2, 0, 1);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
                double x1 = Math.min(dst1[0], dst2[0]);
                double y1 = Math.min(dst1[1], dst2[1]);
                double x2 = Math.max(dst1[0], dst2[0]);
                double y2 = Math.max(dst1[1], dst2[1]);
                this.jsBbox = bbox = "[" + x1 + "," + y1 + "," + x2 + "," + y2 + "]";
                double width = x2 - x1;
                double height = y2 - y1;
                this.jsMaxResolution = maxres = this.getMaxResolution(width, height);
            }
        }
        this.add((Component)new Label("crsScope", scope == null ? "-" : scope.toString(locale)));
        this.add((Component)new Label("crsRemarks", remarks == null ? "-" : remarks.toString(locale)));
        this.add((Component)new Label("wkt", wkt));
        this.add((Component)new Label("aovCoords", aovCoords));
        this.add((Component)new Label("aovDescription", areaOfValidity));
        Image aovMap = new Image("aovMap", (Resource)new TestResource(crs));
        this.add((Component)aovMap);
    }

    private double getMaxResolution(double w, double h) {
        return 4.0 * ((w > h ? w : h) / 256.0);
    }
}

