/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.wicket.EditAreaBehavior;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class DemoRequestsPage
extends GeoServerBasePage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.demo");
    private final DemoRequestsModel model;

    public DemoRequestsPage() {
        File demoDir;
        try {
            demoDir = GeoserverDataDirectory.findCreateConfigDir((String)"demo/");
        }
        catch (ConfigurationException e) {
            throw new WicketRuntimeException("Can't access demo requests directory: " + e.getMessage());
        }
        this.model = new DemoRequestsModel(demoDir);
        this.setUpRequestSelectionForm();
        this.setUpRequestSumbitionForm();
    }

    private void setUpRequestSumbitionForm() {
        Form testWfsPostForm = new Form("TestWfsPostForm");
        this.add((Component)testWfsPostForm);
        TextField urlTextField = new TextField("url", (IModel)new PropertyModel((Object)this.model, "requestUrl"));
        testWfsPostForm.add((Component)urlTextField);
        TextArea body = new TextArea("body", (IModel)new PropertyModel((Object)this.model, "requestBody"));
        body.setMarkupId("body");
        body.setOutputMarkupId(true);
        body.add((IBehavior)new EditAreaBehavior());
        testWfsPostForm.add((Component)body);
        TextField username = new TextField("username", (IModel)new PropertyModel((Object)this.model, "userName"));
        testWfsPostForm.add((Component)username);
        PasswordTextField password = new PasswordTextField("password", (IModel)new PropertyModel((Object)this.model, "password"));
        password.setRequired(false);
        testWfsPostForm.add((Component)password);
        final ModalWindow responseWindow = new ModalWindow("responseWindow");
        this.add((Component)responseWindow);
        responseWindow.setPageMapName("demoResponse");
        responseWindow.setCookieName("demoResponse");
        responseWindow.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new DemoRequestResponse(DemoRequestsPage.this.model);
            }
        });
        testWfsPostForm.add((Component)new AjaxSubmitLink("submit", testWfsPostForm){

            public void onSubmit(AjaxRequestTarget target, Form testWfsPostForm) {
                responseWindow.show(target);
            }
        });
    }

    private void setUpRequestSelectionForm() {
        Form selectForm = new Form("selectForm");
        this.add((Component)selectForm);
        ArrayList<String> demoList = new ArrayList<String>();
        for (File file : this.model.getDemoDir().listFiles()) {
            if (file.isDirectory()) continue;
            String name = file.getName();
            if (name.endsWith(".url") || name.endsWith(".xml")) {
                demoList.add(name);
                continue;
            }
            LOGGER.warning("Ignoring file " + name + " in demo requests directory, only .url and .xml files allowed");
        }
        Collections.sort(demoList);
        DemoRequestsDropDown demoRequestsList = new DemoRequestsDropDown("demoRequestsList", this.model, demoList);
        selectForm.add((Component)demoRequestsList);
    }

    private static class DemoRequestsDropDown
    extends DropDownChoice {
        private DemoRequestsModel demosModel;

        public DemoRequestsDropDown(String id, DemoRequestsModel model, List<String> demoList) {
            super(id, (IModel)new Model(), demoList);
            this.demosModel = model;
        }

        protected boolean wantOnSelectionChangedNotifications() {
            return true;
        }

        protected void onSelectionChanged(Object newSelection) {
            String contents;
            String reqFileName = (String)newSelection;
            Request request = super.getWebPage().getRequest();
            if (!(request instanceof WebRequest)) {
                throw new RuntimeException("request is not a WebRequest, shouldn't happen!");
            }
            HttpServletRequest httpServletRequest = ((WebRequest)request).getHttpServletRequest();
            String baseUrl = RequestUtils.baseURL((HttpServletRequest)httpServletRequest);
            try {
                contents = this.demosModel.getFileContents(reqFileName);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Can't load demo file " + reqFileName, e);
                throw new WicketRuntimeException("Can't load demo file");
            }
            boolean demoRequestIsHttpGet = reqFileName.endsWith(".url");
            String service = reqFileName.substring(0, reqFileName.indexOf(95)).toLowerCase();
            String serviceUrl = baseUrl + service;
            if (demoRequestIsHttpGet) {
                this.demosModel.setRequestUrl(baseUrl + contents);
                this.demosModel.setRequestBody(null);
            } else {
                this.demosModel.setRequestUrl(serviceUrl);
                this.demosModel.setRequestBody(contents);
            }
        }
    }

    public static class DemoRequestsModel
    implements Serializable {
        private final File demoDir;
        private String requestFileName;
        private String requestUrl;
        private String requestBody;
        private String userName;
        private String password;

        DemoRequestsModel(File demoDir) {
            this.demoDir = demoDir;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getRequestFileName() {
            return this.requestFileName;
        }

        public void setRequestFileName(String requestFileName) {
            this.requestFileName = requestFileName;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }

        public void setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
        }

        public String getRequestBody() {
            return this.requestBody;
        }

        public void setRequestBody(String requestBody) {
            this.requestBody = requestBody;
        }

        public File getDemoDir() {
            return this.demoDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFileContents(String reqFileName) throws IOException {
            File file = new File(this.demoDir, reqFileName);
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            finally {
                reader.close();
            }
            return sb.toString();
        }
    }
}

