/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import java.util.Locale;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.GeoserverUserDao;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.security.user.NewUserPage;
import org.geoserver.web.security.user.UserPage;

public class NewUserPageTest
extends GeoServerWicketTestSupport {
    private GeoserverUserDao dao;

    protected void setUpInternal() throws Exception {
        this.dao = GeoserverUserDao.get();
        this.login();
        tester.startPage((Page)new NewUserPage());
    }

    public void testRenders() {
        tester.assertRenderedPage(NewUserPage.class);
    }

    public void testFill() {
        Locale.setDefault(Locale.ENGLISH);
        tester.assertComponent("userForm:roles:roles:recorder", Recorder.class);
        FormTester form = tester.newFormTester("userForm");
        form.setValue("username", "user");
        form.setValue("password", "pwd");
        form.setValue("confirmPassword", "pwd");
        form.setValue("roles:roles:recorder", "ROLE_FOO1");
        form.submit("save");
        tester.assertErrorMessages(new String[0]);
        tester.assertRenderedPage(UserPage.class);
        this.dao.reload();
        UserDetails user = this.dao.loadUserByUsername("user");
        NewUserPageTest.assertEquals((String)"pwd", (String)user.getPassword());
    }
}

