/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.wcs.web.demo.GetCoverageRequest;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

class WCS10GetCoverageTransformer
extends TransformerBase {
    static final Logger LOGGER = Logging.getLogger(WCS10GetCoverageTransformer.class);
    private Catalog catalog;

    public WCS10GetCoverageTransformer(Catalog catalog) {
        this.catalog = catalog;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new ExecuteRequestTranslator(handler);
    }

    public class ExecuteRequestTranslator
    extends TransformerBase.TranslatorSupport {
        protected static final String WFS_URI = "http://www.opengis.net/wfs";
        protected static final String WCS_URI = "http://www.opengis.net/wcs";
        protected static final String XSI_PREFIX = "xsi";
        protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

        public ExecuteRequestTranslator(ContentHandler ch) {
            super(ch, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            GetCoverageRequest request = (GetCoverageRequest)o;
            this.encode(request);
        }

        private void encode(GetCoverageRequest request) {
            AttributesImpl attributes = this.attributes("version", "1.0.0", "service", "WCS", "xmlns:xsi", XSI_URI, "xmlns", WCS_URI, "xmlns:ows", "http://www.opengis.net/ows/1.1", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", "http://www.opengis.net/ogc", "xsi:schemaLocation", "http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/getCoverage.xsd");
            this.start("GetCoverage", attributes);
            this.element("sourceCoverage", request.coverage);
            CoverageInfo coverage = WCS10GetCoverageTransformer.this.catalog.getCoverageByName(request.coverage);
            this.start("domainSubset");
            this.handleSpatialSubset(request, coverage);
            this.end("domainSubset");
            this.handleOutput(request);
            this.end("GetCoverage");
        }

        private void handleOutput(GetCoverageRequest request) {
            this.start("output");
            if (request.targetCRS != null) {
                this.element("crs", this.epsgCode(request.targetCRS));
            }
            this.element("format", request.outputFormat);
            this.end("output");
        }

        void handleSpatialSubset(GetCoverageRequest request, CoverageInfo coverage) {
            this.start("spatialSubset");
            ReferencedEnvelope bounds = request.bounds;
            CoordinateReferenceSystem boundsCrs = bounds.getCoordinateReferenceSystem();
            String epsgCode = this.epsgCode(boundsCrs);
            this.start("gml:Envelope", this.attributes("srsName", epsgCode));
            this.element("gml:pos", String.valueOf(bounds.getMinX()) + " " + bounds.getMinY());
            this.element("gml:pos", String.valueOf(bounds.getMaxX()) + " " + bounds.getMaxY());
            this.end("gml:Envelope");
            this.start("gml:Grid", this.attributes("dimension", "2"));
            GridEnvelope2D limits = request.sourceGridRange;
            this.start("gml:limits");
            this.start("gml:GridEnvelope");
            this.element("gml:low", String.valueOf((int)limits.getMinX()) + " " + (int)limits.getMinY());
            this.element("gml:high", String.valueOf((int)limits.getMaxX()) + " " + (int)limits.getMaxY());
            this.end("gml:GridEnvelope");
            this.end("gml:limits");
            CoordinateReferenceSystem gridCrs = coverage.getCRS();
            int dn = 0;
            while (dn < gridCrs.getCoordinateSystem().getDimension()) {
                String axisName = gridCrs.getCoordinateSystem().getAxis(dn).getAbbreviation();
                axisName = axisName.toLowerCase().startsWith("lon") ? "x" : axisName;
                axisName = axisName.toLowerCase().startsWith("lat") ? "y" : axisName;
                this.element("gml:axisName", axisName);
                ++dn;
            }
            this.end("gml:Grid");
            this.end("spatialSubset");
        }

        private String epsgCode(CoordinateReferenceSystem boundsCrs) {
            try {
                int epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)boundsCrs, (boolean)false);
                String epsgCode = "EPSG:" + epsg;
                return epsgCode;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        AttributesImpl attributes(String ... nameValues) {
            AttributesImpl atts = new AttributesImpl();
            int i = 0;
            while (i < nameValues.length) {
                String name = nameValues[i];
                String valu = nameValues[i + 1];
                atts.addAttribute(null, null, name, null, valu);
                i += 2;
            }
            return atts;
        }
    }
}

